/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.environment;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.deps.org.json.simple.JSONStreamAware;
import com.newrelic.agent.environment.AgentIdentity;
import com.newrelic.agent.environment.EnvironmentChangeListener;
import com.newrelic.agent.platform.PlatformInfo;
import java.io.IOException;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Environment
implements JSONStreamAware,
Cloneable {
    public static final String PHYSICAL_CORE_KEY = "Physical Processors";
    private static final String LOGICAL_CORE_KEY = "Logical Processors";
    private static final String TOTAL_MEMORY_MB = "Total Physical Memory (MB)";
    private static final String SOLR_VERSION_KEY = "Solr Version";
    private static final Pattern JSON_WORKAROUND = Pattern.compile("\\\\+$");
    private final List<EnvironmentChangeListener> listeners = Lists.newCopyOnWriteArrayList();
    private final List<List<?>> environmentMap = new ArrayList();
    private volatile AgentIdentity agentIdentity;
    private PlatformInfo platformInfo;
    private volatile Integer physicalCoreCount;
    private volatile Float physicalMemoryMB;
    private volatile Object solrVersion;

    public Environment(AgentConfig config, String logFilePath) {
        if (config.isSendEnvironmentInfo()) {
            OperatingSystemMXBean systemMXBean = ManagementFactory.getOperatingSystemMXBean();
            this.addVariable(LOGICAL_CORE_KEY, systemMXBean.getAvailableProcessors());
            this.addVariable("Arch", systemMXBean.getArch());
            this.addVariable("OS version", systemMXBean.getVersion());
            this.addVariable("OS", systemMXBean.getName());
            this.addVariable("Java vendor", System.getProperty("java.vendor"));
            this.addVariable("Java VM", System.getProperty("java.vm.name"));
            this.addVariable("Java VM version", System.getProperty("java.vm.version"));
            this.addVariable("Java version", System.getProperty("java.version"));
            this.addVariable("Log path", logFilePath);
            MemoryUsage heapMemoryUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
            this.addVariable("Heap initial (MB)", Float.valueOf((float)heapMemoryUsage.getInit() / 1048576.0f));
            this.addVariable("Heap max (MB)", Float.valueOf((float)heapMemoryUsage.getMax() / 1048576.0f));
            if (config.isSendJvmProps()) {
                RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
                List<String> inputArguments = Environment.fixInputArguments(runtimeMXBean.getInputArguments());
                this.environmentMap.add(Arrays.asList("JVM arguments", inputArguments));
            }
            this.platformInfo = PlatformInfo.create(config);
        }
        String dispatcher = null;
        if (System.getProperty("com.sun.aas.installRoot") != null) {
            dispatcher = "Glassfish";
        } else if (System.getProperty("resin.home") != null) {
            dispatcher = "Resin";
        } else if (System.getProperty("org.apache.geronimo.base.dir") != null) {
            dispatcher = "Apache Geronimo";
        } else if (System.getProperty("weblogic.home") != null) {
            dispatcher = "WebLogic";
        } else if (System.getProperty("was.install.root") != null) {
            dispatcher = "IBM WebSphere Application Server";
        } else if (System.getProperty("jboss.home") != null) {
            dispatcher = "JBoss";
        } else if (System.getProperty("catalina.home") != null) {
            dispatcher = "Apache Tomcat";
        } else if (System.getProperty("jetty.home") != null) {
            dispatcher = "Jetty";
        }
        this.addVariable("Framework", "java");
        Number appServerPort = (Number)config.getProperty("appserver_port");
        Integer serverPort = null;
        if (appServerPort != null) {
            serverPort = appServerPort.intValue();
        }
        String instanceName = (String)config.getProperty("instance_name");
        this.agentIdentity = new AgentIdentity(dispatcher, null, serverPort, instanceName);
    }

    public void addEnvironmentChangeListener(EnvironmentChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeEnvironmentChangeListener(EnvironmentChangeListener listener) {
        this.listeners.remove(listener);
    }

    private static List<String> fixInputArguments(List<String> args) {
        ArrayList<String> fixed = new ArrayList<String>(args.size());
        for (String arg : args) {
            fixed.add(Environment.fixString(arg));
        }
        return fixed;
    }

    static String fixString(String arg) {
        Matcher matcher = JSON_WORKAROUND.matcher(arg);
        return matcher.replaceAll("");
    }

    public void setServerPort(Integer port) {
        AgentIdentity newIdentity = this.agentIdentity.createWithNewServerPort(port);
        if (newIdentity == null) {
            Agent.LOG.finest("Application server port already set, not changing it to port " + port);
        } else {
            Agent.LOG.finer("Application server port: " + port);
            this.agentIdentity = newIdentity;
            this.notifyListenersIdentityChanged();
        }
    }

    public void setInstanceName(String instanceName) {
        AgentIdentity newIdentity = this.agentIdentity.createWithNewInstanceName(instanceName);
        if (newIdentity == null) {
            Agent.LOG.finest("Instance Name already set, not changing it to " + instanceName);
        } else {
            Agent.LOG.finer("Application server instance name: " + instanceName);
            this.agentIdentity = newIdentity;
            this.notifyListenersIdentityChanged();
        }
    }

    private void notifyListenersIdentityChanged() {
        for (EnvironmentChangeListener listener : this.listeners) {
            listener.agentIdentityChanged(this.agentIdentity);
        }
    }

    public AgentIdentity getAgentIdentity() {
        return this.agentIdentity;
    }

    public void addSolrVersion(Object version) {
        if (this.solrVersion == null && version != null) {
            Agent.LOG.fine("Setting environment variable: Solr Version: " + version);
            this.solrVersion = version;
            this.notifyListenersIdentityChanged();
        } else if (version != null) {
            Agent.LOG.finest("Solr version already set, not changing it to version " + version);
        }
    }

    private void addVariable(String name, Object value) {
        this.environmentMap.add(Arrays.asList(name, value));
    }

    public Object getVariable(String name) {
        for (List<?> item : this.environmentMap) {
            if (!name.equals(item.get(0))) continue;
            return item.get(1);
        }
        return null;
    }

    @Override
    public void writeJSONString(Writer writer) throws IOException {
        ArrayList map = new ArrayList(this.environmentMap);
        map.add(Arrays.asList("Dispatcher", this.agentIdentity.getDispatcher()));
        map.add(Arrays.asList(PHYSICAL_CORE_KEY, this.physicalCoreCount));
        map.add(Arrays.asList(TOTAL_MEMORY_MB, this.physicalMemoryMB));
        if (this.agentIdentity.getDispatcherVersion() != null) {
            map.add(Arrays.asList("Dispatcher Version", this.agentIdentity.getDispatcherVersion()));
        }
        if (this.agentIdentity.getServerPort() != null) {
            map.add(Arrays.asList("Server port", this.agentIdentity.getServerPort()));
        }
        if (this.agentIdentity.getInstanceName() != null) {
            map.add(Arrays.asList("Instance Name", this.agentIdentity.getInstanceName()));
        }
        if (this.solrVersion != null) {
            map.add(Arrays.asList(SOLR_VERSION_KEY, this.solrVersion));
        }
        JSONArray.writeJSONString(map, writer);
    }

    public void setServerInfo(String dispatcherName, String version) {
        AgentIdentity newIdentity = this.agentIdentity.createWithNewDispatcher(dispatcherName, version);
        if (newIdentity != null) {
            this.agentIdentity = newIdentity;
            Agent.LOG.log(Level.FINER, "The dispatcher was set to {0}:{1}.", new Object[]{dispatcherName, version});
            this.notifyListenersIdentityChanged();
        }
    }

    public void setServerInfo(String serverInfo) {
        Agent.LOG.config("Server Info: " + serverInfo);
        String[] info = serverInfo.split("/");
        if (info.length == 2) {
            this.setServerInfo(info[0], info[1]);
        }
    }
}

