/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.errors;

import com.newrelic.agent.errors.TracedError;
import com.newrelic.agent.util.StackTraces;
import java.lang.management.ThreadInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeadlockTraceError
extends TracedError {
    private final String message;
    private final String exceptionClass;
    private final Map<String, StackTraceElement[]> stackTraces;

    private DeadlockTraceError(String appName, String frontendMetricName, String message, String exceptionClass, Map<String, StackTraceElement[]> stackTraces, String requestPath, Map<String, String> params) {
        super(appName, frontendMetricName, requestPath, System.currentTimeMillis(), null, null, null, params, null);
        this.stackTraces = stackTraces;
        this.message = message;
        this.exceptionClass = exceptionClass;
    }

    public DeadlockTraceError(String appName, ThreadInfo thread, Map<String, StackTraceElement[]> stackTraces, Map<String, String> params) {
        this(appName, "Deadlock", "Deadlocked thread: " + thread.getThreadName(), "Deadlock", stackTraces, "", params);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getExceptionClass() {
        return this.exceptionClass;
    }

    @Override
    public Collection<String> stackTrace() {
        return null;
    }

    @Override
    public boolean incrementsErrorMetric() {
        return false;
    }

    @Override
    public Map<String, Collection<String>> stackTraces() {
        HashMap<String, Collection<String>> traces = new HashMap<String, Collection<String>>();
        for (Map.Entry<String, StackTraceElement[]> entry : this.stackTraces.entrySet()) {
            traces.put(entry.getKey(), StackTraces.stackTracesToStrings(entry.getValue()));
        }
        return traces;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.stackTraces == null ? 0 : this.stackTraces.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeadlockTraceError other = (DeadlockTraceError)obj;
        return !(this.stackTraces == null ? other.stackTraces != null : !this.stackTraces.equals(other.stackTraces));
    }
}

