/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.errors;

import com.newrelic.agent.attributes.AttributesUtils;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.deps.org.json.simple.JSONStreamAware;
import com.newrelic.agent.service.ServiceFactory;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TracedError
implements Comparable<TracedError>,
JSONStreamAware {
    private final String path;
    private final long timestamp;
    private final String requestUri;
    private final String appName;
    private final Map<String, Map<String, String>> prefixAtts;
    private final Map<String, Object> userAtts;
    private final Map<String, Object> agentAtts;
    private final Map<String, String> errorAtts;
    private final Map<String, Object> intrinsics;

    public TracedError(String appName, String frontendMetricName, String requestPath, long timestamp, Map<String, Map<String, String>> prefixedParams, Map<String, Object> userParams, Map<String, Object> agentParams, Map<String, String> errorParams, Map<String, Object> intrinsics) {
        this.appName = appName;
        this.path = frontendMetricName == null ? "Unknown" : frontendMetricName;
        this.requestUri = requestPath == null ? "Unknown" : requestPath;
        this.timestamp = timestamp;
        this.prefixAtts = this.setAtts(prefixedParams);
        this.userAtts = this.setAtts(userParams);
        this.agentAtts = this.setAtts(agentParams);
        this.errorAtts = this.setAtts(errorParams);
        this.intrinsics = this.setAtts(intrinsics);
    }

    private <V, K> Map<K, V> setAtts(Map<K, V> inputAtts) {
        if (inputAtts == null) {
            return Collections.emptyMap();
        }
        return inputAtts;
    }

    public abstract String getMessage();

    public abstract String getExceptionClass();

    public long getTimestamp() {
        return this.timestamp / 1000L;
    }

    public String getPath() {
        return this.path;
    }

    public abstract Collection<String> stackTrace();

    public Map<String, Collection<String>> stackTraces() {
        return Collections.emptyMap();
    }

    private Map<String, Object> getUserAtts() {
        HashMap<String, Object> atts = Maps.newHashMap();
        atts.putAll(this.errorAtts);
        atts.putAll(this.userAtts);
        return atts;
    }

    private Map<String, Object> getAgentAtts() {
        HashMap<String, Object> atts = Maps.newHashMap();
        atts.putAll(this.agentAtts);
        if (this.prefixAtts != null && !this.prefixAtts.isEmpty()) {
            atts.putAll(AttributesUtils.appendAttributePrefixes(this.prefixAtts));
        }
        return atts;
    }

    private void filterAndAddIfNotEmpty(String key, Map<String, Object> wheretoAdd, Map<String, ? extends Object> toAdd) {
        Map<String, ? extends Object> output = ServiceFactory.getAttributesService().filterErrorAttributes(this.appName, toAdd);
        if (output != null && !output.isEmpty()) {
            wheretoAdd.put(key, output);
        }
    }

    private Map<String, Object> getAttributes() {
        Collection<String> stackTrace;
        HashMap<String, Object> params = Maps.newHashMap();
        if (ServiceFactory.getAttributesService().isAttributesEnabledForErrors(this.appName)) {
            this.filterAndAddIfNotEmpty("agentAttributes", params, this.getAgentAtts());
            if (!ServiceFactory.getConfigService().getDefaultAgentConfig().isHighSecurity()) {
                this.filterAndAddIfNotEmpty("userAttributes", params, this.getUserAtts());
            }
        }
        if (this.intrinsics != null && !this.intrinsics.isEmpty()) {
            params.put("intrinsics", this.intrinsics);
        }
        if ((stackTrace = this.stackTrace()) != null) {
            params.put("stack_trace", stackTrace);
        } else {
            Map<String, Collection<String>> stackTraces = this.stackTraces();
            if (stackTraces != null) {
                params.put("stack_traces", stackTraces);
            }
        }
        params.put("request_uri", this.requestUri);
        return params;
    }

    @Override
    public void writeJSONString(Writer writer) throws IOException {
        JSONArray.writeJSONString(Arrays.asList(this.getTimestamp(), this.getPath(), this.getMessage(), this.getExceptionClass(), this.getAttributes()), writer);
    }

    @Override
    public int compareTo(TracedError other) {
        return (int)(this.timestamp - other.timestamp);
    }

    public boolean incrementsErrorMetric() {
        return true;
    }
}

