/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.extension;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.extension.Extension;
import com.newrelic.agent.extension.ExtensionParsers;
import com.newrelic.agent.extension.ExtensionRewriter;
import com.newrelic.agent.instrumentation.weaver.WeaveUtils;
import com.newrelic.agent.logging.IAgentLogger;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.util.Streams;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarExtension {
    private final ClassLoader classloader;
    private final File file;
    private final Map<String, Extension> extensions = new HashMap<String, Extension>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JarExtension create(IAgentLogger logger, ExtensionParsers extensionParsers, File file) throws IOException {
        String agentClass;
        JarFile jar = new JarFile(file);
        try {
            agentClass = JarExtension.getAgentClass(jar.getManifest());
            if (null != agentClass) {
                logger.log(Level.FINE, "Detected agentmain class {0} in {1}", new Object[]{agentClass, file.getAbsolutePath()});
                byte[] newBytes = ExtensionRewriter.rewrite(jar);
                if (null != newBytes) {
                    JarExtension.validateJar(newBytes);
                    file = JarExtension.writeTempJar(logger, file, newBytes);
                }
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            jar.close();
            throw throwable;
        }
        jar.close();
        JarExtension ext = new JarExtension(logger, extensionParsers, file, new URLClassLoader(new URL[]{file.toURI().toURL()}, ClassLoader.getSystemClassLoader()), true);
        if (agentClass != null) {
            ext.invokeMainMethod(logger, agentClass);
        }
        return ext;
    }

    public static JarExtension create(IAgentLogger logger, ExtensionParsers extensionParsers, String jarFileName) throws IOException {
        return new JarExtension(logger, extensionParsers, new File(jarFileName), ClassLoader.getSystemClassLoader(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JarExtension(IAgentLogger logger, ExtensionParsers extensionParsers, File file, ClassLoader classLoader, boolean custom) throws IOException {
        this.classloader = classLoader;
        this.file = file;
        JarFile jarFile = new JarFile(file);
        logger.fine(MessageFormat.format(!custom ? "Loading built-in agent extensions" : "Loading extension jar \"{0}\"", file.getAbsolutePath()));
        Collection<JarEntry> entries = JarExtension.getExtensions(jarFile);
        for (JarEntry entry : entries) {
            Exception e2;
            Object var13_13;
            InputStream iStream = null;
            try {
                iStream = jarFile.getInputStream(entry);
                if (iStream != null) {
                    try {
                        Extension extension = extensionParsers.getParser(entry.getName()).parse(classLoader, iStream, custom);
                        this.addExtension(extension);
                    }
                    catch (Exception ex) {
                        logger.severe(MessageFormat.format("Invalid extension file {0} : {1}", entry.getName(), ex.toString()));
                        logger.log(Level.FINER, ex.toString(), ex);
                    }
                } else {
                    logger.fine(MessageFormat.format("Unable to load extension resource \"{0}\"", entry.getName()));
                }
                var13_13 = null;
                if (iStream == null) continue;
            }
            catch (Throwable throwable) {
                var13_13 = null;
                if (iStream != null) {
                    try {
                        iStream.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                iStream.close();
            }
            catch (Exception e2) {}
        }
    }

    public ClassLoader getClassloader() {
        return this.classloader;
    }

    public final Map<String, Extension> getExtensions() {
        return Collections.unmodifiableMap(this.extensions);
    }

    void addExtension(Extension extension) {
        Extension existing = this.extensions.get(extension.getName());
        if (existing == null || existing.getVersionNumber() < extension.getVersionNumber()) {
            this.extensions.put(extension.getName(), extension);
        }
    }

    private static Collection<JarEntry> getExtensions(JarFile file) {
        ArrayList<JarEntry> list = new ArrayList<JarEntry>();
        Pattern pattern = Pattern.compile("^META-INF/extensions/(.*).(yml|xml)$");
        Enumeration<JarEntry> entries = file.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!pattern.matcher(name).matches()) continue;
            list.add(entry);
        }
        return list;
    }

    public boolean isWeaveInstrumentation() {
        return JarExtension.isWeaveInstrumentation(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isWeaveInstrumentation(File file) {
        block23: {
            block22: {
                classNames = JarExtension.getClassFileNames(file);
                if (classNames.isEmpty() != false) return false;
                if (!file.exists()) {
                    return false;
                }
                jarFile = null;
                try {
                    try {
                        jarFile = new JarFile(file);
                        for (String fileName : classNames) {
                            jarEntry = jarFile.getJarEntry(fileName);
                            stream = null;
                            try {
                                stream = jarFile.getInputStream(jarEntry);
                                if (stream == null || !WeaveUtils.isWeavedClass(reader = new ClassReader(stream))) ** GOTO lbl41
                                var8_12 = true;
                                var10_10 = null;
                                if (stream == null) ** GOTO lbl37
                                ** GOTO lbl32
                            }
                            catch (IOException e) {
                                block24: {
                                    block25: {
                                        break block24;
                                        catch (Throwable var9_21) {
                                            var10_10 = null;
                                            if (stream == null) throw var9_21;
                                            try {
                                                stream.close();
                                                throw var9_21;
                                            }
                                            catch (IOException e) {
                                                // empty catch block
                                            }
                                            throw var9_21;
                                        }
lbl32:
                                        // 1 sources

                                        ** try [egrp 4[TRYBLOCK] [5 : 179->187)] { 
lbl33:
                                        // 1 sources

                                        stream.close();
                                        break block25;
lbl35:
                                        // 1 sources

                                        catch (IOException e) {
                                        }
                                    }
                                    var13_13 = null;
                                    if (jarFile == null) return var8_12;
                                    break block22;
lbl41:
                                    // 1 sources

                                    var10_10 = null;
                                    if (stream == null) continue;
                                    try {}
                                    catch (IOException e) {}
                                    stream.close();
                                    continue;
                                }
                                Agent.LOG.log(Level.INFO, "Error processing " + fileName, e);
                                var10_10 = null;
                                if (stream == null) continue;
                                try {}
                                catch (IOException e) {}
                                stream.close();
                            }
                        }
                        break block23;
                    }
                    catch (IOException ex) {
                        Agent.LOG.log(Level.INFO, "Error processing extension jar " + file, ex);
                        var13_15 = null;
                        if (jarFile == null) return false;
                        try {
                            jarFile.close();
                            return false;
                        }
                        catch (IOException e) {
                            return false;
                        }
                    }
                }
                catch (Throwable var12_22) {
                    var13_16 = null;
                    if (jarFile == null) throw var12_22;
                    ** try [egrp 5[TRYBLOCK] [12 : 253->260)] { 
lbl74:
                    // 1 sources

                    jarFile.close();
                    throw var12_22;
lbl76:
                    // 1 sources

                    catch (IOException e) {
                        // empty catch block
                    }
                    throw var12_22;
                }
            }
            try {}
            catch (IOException e) {
                // empty catch block
                return var8_12;
            }
            jarFile.close();
            return var8_12;
        }
        var13_14 = null;
        if (jarFile == null) return false;
        try {}
        catch (IOException e) {}
        jarFile.close();
        return false;
        return false;
    }

    public Collection<String> getClassFileNames() {
        return JarExtension.getClassFileNames(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Collection<String> getClassFileNames(File file) {
        if (!file.exists()) return Collections.emptyList();
        JarFile jarFile = null;
        jarFile = new JarFile(file);
        ArrayList<String> classes = new ArrayList<String>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
            String fileName = entry.getName();
            try {
                classes.add(fileName);
            }
            catch (Exception ex) {}
        }
        ArrayList<String> arrayList = classes;
        Object var8_8 = null;
        if (jarFile == null) return arrayList;
        try {
            jarFile.close();
            return arrayList;
        }
        catch (IOException e2) {
            // empty catch block
        }
        return arrayList;
        catch (IOException e) {
            try {
                Agent.LOG.debug("Unable to read classes in " + file.getAbsolutePath() + ".  " + e.getMessage());
                Object var8_9 = null;
                if (jarFile == null) return Collections.emptyList();
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (jarFile == null) throw throwable;
                try {
                    jarFile.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                jarFile.close();
                return Collections.emptyList();
            }
            catch (IOException e2) {}
            return Collections.emptyList();
        }
    }

    public Collection<Class<?>> getClasses() {
        Collection<String> classNames = this.getClassFileNames();
        if (classNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Class<?>> classes = Lists.newArrayList();
        for (String fileName : classNames) {
            int index = fileName.indexOf(".class");
            fileName = fileName.substring(0, index);
            fileName = fileName.replace('/', '.');
            try {
                classes.add(this.classloader.loadClass(fileName));
            }
            catch (Exception ex) {}
        }
        return classes;
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return this.file.getAbsolutePath();
    }

    private static String getAgentClass(Manifest manifest) {
        for (String attr : Arrays.asList("Agent-Class", "Premain-Class")) {
            String agentClass = manifest.getMainAttributes().getValue(attr);
            if (null == agentClass) continue;
            return agentClass;
        }
        return null;
    }

    private void invokeMainMethod(IAgentLogger logger, String agentClass) {
        try {
            Class<?> clazz = this.classloader.loadClass(agentClass);
            logger.log(Level.FINE, "Invoking {0}.premain method", new Object[]{agentClass});
            Method method = clazz.getDeclaredMethod("premain", String.class, Instrumentation.class);
            String agentArgs = "";
            method.invoke(null, agentArgs, ServiceFactory.getClassTransformerService().getExtensionInstrumentation());
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.INFO, "Unable to load {0}", new Object[]{agentClass});
            logger.log(Level.FINEST, e, e.getMessage(), new Object[0]);
        }
        catch (NoSuchMethodException e) {
            logger.log(Level.INFO, "{0} has no premain method", new Object[]{agentClass});
            logger.log(Level.FINEST, e, e.getMessage(), new Object[0]);
        }
        catch (SecurityException e) {
            logger.log(Level.INFO, "Unable to load {0}", new Object[]{agentClass});
            logger.log(Level.FINEST, e, e.getMessage(), new Object[0]);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Unable to invoke {0}.premain", new Object[]{agentClass});
            logger.log(Level.FINEST, e, e.getMessage(), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File writeTempJar(IAgentLogger logger, File file, byte[] newBytes) throws IOException {
        File original = file;
        file = File.createTempFile(file.getName(), ".jar");
        file.deleteOnExit();
        FileOutputStream out = new FileOutputStream(file);
        try {
            Streams.copy(new ByteArrayInputStream(newBytes), out);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            out.close();
            throw throwable;
        }
        out.close();
        logger.log(Level.FINER, "Rewriting {0} as {1}", new Object[]{original.getAbsolutePath(), file.getAbsolutePath()});
        return file;
    }

    private static void validateJar(byte[] bytes) throws IOException {
    }
}

