/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.FieldVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.GeneratorAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.FieldAccessor;
import com.newrelic.agent.instrumentation.InstrumentationUtils;
import com.newrelic.agent.instrumentation.StopProcessingException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldAccessorGeneratingClassAdapter
extends ClassVisitor {
    private final String className;
    private final Map<String, String> allFields = new HashMap<String, String>();
    private final java.lang.reflect.Method[] methods;
    private final boolean hasFieldAccessors;

    public FieldAccessorGeneratingClassAdapter(ClassVisitor cv, String className, Class<?> extensionClass) {
        super(327680, cv);
        this.className = className;
        this.methods = extensionClass.getMethods();
        this.hasFieldAccessors = this.hasFieldAccessors();
    }

    private boolean hasFieldAccessors() {
        for (java.lang.reflect.Method method : this.methods) {
            if (method.getAnnotation(FieldAccessor.class) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (this.hasFieldAccessors) {
            this.allFields.put(name, desc);
        }
        return super.visitField(access, name, desc, signature, value);
    }

    @Override
    public void visitEnd() {
        if (this.hasFieldAccessors) {
            this.addFieldAccessors();
        }
        super.visitEnd();
    }

    private void addFieldAccessors() {
        HashMap<String, Object[]> fields = new HashMap<String, Object[]>();
        for (java.lang.reflect.Method method : this.methods) {
            Type returnType2;
            Class type;
            Class<?>[] parameterTypes;
            FieldAccessor fieldAccessor = method.getAnnotation(FieldAccessor.class);
            if (fieldAccessor == null) continue;
            Class<?> returnType = method.getReturnType();
            if (Void.TYPE.equals(returnType) && (parameterTypes = method.getParameterTypes()).length == 1) {
                returnType = parameterTypes[0];
            }
            String fieldName = (fieldAccessor.existingField() ? "" : "__nr__") + fieldAccessor.fieldName();
            Object[] fieldDesc = (Object[])fields.get(fieldName);
            Class clazz = type = fieldDesc == null ? null : (Class)fieldDesc[0];
            if (type != null && !returnType.equals(type)) {
                throw new StopProcessingException("Method " + method.getName() + " uses type " + type.getName() + ", but " + returnType.getName() + " was expected.");
            }
            if (!fieldAccessor.existingField()) {
                fieldDesc = new Object[]{returnType, fieldAccessor.volatileAccess() ? 194 : 130};
                fields.put(fieldName, fieldDesc);
            } else if (!this.allFields.containsKey(fieldName)) {
                throw new StopProcessingException(this.className + " does not contain a field named " + fieldName);
            }
            Type fieldType = returnType2 = Type.getType(returnType);
            if (fieldAccessor.fieldDesc().length() > 0) {
                fieldType = Type.getType(fieldAccessor.fieldDesc());
            }
            this.writeMethod(fieldName, returnType2, fieldType, method);
        }
        for (Map.Entry field : fields.entrySet()) {
            String fieldName = (String)field.getKey();
            Object[] fieldDesc = (Object[])field.getValue();
            Type fieldType = Type.getType((Class)fieldDesc[0]);
            this.cv.visitField((Integer)fieldDesc[1], fieldName, fieldType.getDescriptor(), null, null);
        }
    }

    private void writeMethod(String fieldName, Type returnType, Type fieldType, java.lang.reflect.Method method) {
        boolean setter = Void.TYPE.equals(method.getReturnType());
        Method newMethod = InstrumentationUtils.getMethod(method);
        GeneratorAdapter mv = new GeneratorAdapter(1, newMethod, null, null, this);
        mv.visitCode();
        mv.loadThis();
        if (setter) {
            mv.loadArgs();
        }
        int op = setter ? 181 : 180;
        mv.visitFieldInsn(op, this.className, fieldName, fieldType.getDescriptor());
        op = setter ? 177 : returnType.getOpcode(172);
        mv.visitInsn(op);
        mv.visitMaxs(0, 0);
    }
}

