/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionApiImpl;
import com.newrelic.agent.bridge.ExitTracer;
import com.newrelic.agent.bridge.Instrumentation;
import com.newrelic.agent.bridge.NoOpTransaction;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.InstrumentedClass;
import com.newrelic.agent.instrumentation.InstrumentedMethod;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.HashSafeClassAndMethodMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OptimizedClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.AccessMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.AndMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.GetterSetterMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.NotMethodMatcher;
import com.newrelic.agent.instrumentation.weaver.WeaveInstrumentation;
import com.newrelic.agent.reinstrument.PeriodicRetransformer;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.ClassMethodSignatures;
import com.newrelic.agent.tracers.TracerFlags;
import com.newrelic.agent.util.InsertOnlyArray;
import com.newrelic.api.agent.Logger;
import java.io.Closeable;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrumentationImpl
implements Instrumentation {
    private final Logger logger;
    private final InsertOnlyArray<Object> objectCache = new InsertOnlyArray(16);
    private final Set<Type> weaveClasses = Sets.newSetFromMap(Maps.newConcurrentMap());

    public InstrumentationImpl(Logger logger) {
        this.logger = logger;
    }

    public ExitTracer createTracer(com.newrelic.agent.bridge.Transaction bridgeTx, Object invocationTarget, String className, String methodName, String methodDesc, int signatureId, boolean dispatcher, String metricName, String tracerFactoryName, Object[] args) {
        Transaction transaction = null;
        if (bridgeTx instanceof TransactionApiImpl) {
            transaction = ((TransactionApiImpl)bridgeTx).getTransaction();
        }
        if (transaction == null) {
            return null;
        }
        try {
            if (!dispatcher && !transaction.isStarted() && tracerFactoryName == null) {
                return null;
            }
            if (transaction.getTransactionActivity().isFlyweight()) {
                return null;
            }
            ClassMethodSignature sig = ClassMethodSignatures.get().get(signatureId);
            return transaction.getTransactionState().getTracer(transaction, tracerFactoryName, sig, invocationTarget, args);
        }
        catch (Throwable t) {
            this.logger.log(Level.FINEST, "Tracer error ", new Object[]{className, Character.valueOf('.'), methodName, methodDesc, t});
            return null;
        }
    }

    public ExitTracer createTracer(com.newrelic.agent.bridge.Transaction bridgeTx, Object invocationTarget, String className, String methodName, String methodDesc, int signatureId, String metricName, int flags) {
        Transaction transaction = null;
        if (bridgeTx instanceof TransactionApiImpl) {
            transaction = ((TransactionApiImpl)bridgeTx).getTransaction();
        }
        if (transaction == null) {
            return null;
        }
        try {
            if (!TracerFlags.isDispatcher(flags) && !transaction.isStarted()) {
                return null;
            }
            if (transaction.getTransactionActivity().isFlyweight()) {
                return null;
            }
            ClassMethodSignature sig = ClassMethodSignatures.get().get(signatureId);
            return transaction.getTransactionState().getTracer(transaction, invocationTarget, sig, metricName, flags);
        }
        catch (Throwable t) {
            this.logger.log(Level.FINEST, t, "Tracer error {0}.{1}{2}", new Object[]{className, methodName, methodDesc});
            return null;
        }
    }

    public void noticeInstrumentationError(Throwable throwable, String libraryName) {
        if (Agent.LOG.isFinerEnabled()) {
            this.logger.log(Level.FINER, "An error was thrown from instrumentation library ", new Object[]{libraryName});
            this.logger.log(Level.FINEST, throwable, "An error was thrown from instrumentation library ", new Object[]{libraryName});
        }
    }

    public void instrument(String className, String metricPrefix) {
        HashSafeClassAndMethodMatcher matcher = new HashSafeClassAndMethodMatcher(new ExactClassMatcher(className), AndMethodMatcher.getMethodMatcher(new AccessMethodMatcher(1), new NotMethodMatcher(GetterSetterMethodMatcher.getGetterSetterMethodMatcher())));
        ServiceFactory.getClassTransformerService().addTraceMatcher(matcher, metricPrefix);
    }

    public void instrument(java.lang.reflect.Method methodToInstrument, String metricPrefix) {
        if (methodToInstrument.isAnnotationPresent(InstrumentedMethod.class)) {
            return;
        }
        if (OptimizedClassMatcher.METHODS_WE_NEVER_INSTRUMENT.contains(Method.getMethod(methodToInstrument))) {
            return;
        }
        int modifiers = methodToInstrument.getModifiers();
        if (Modifier.isNative(modifiers) || Modifier.isAbstract(modifiers)) {
            return;
        }
        Class<?> declaringClass = methodToInstrument.getDeclaringClass();
        HashSafeClassAndMethodMatcher matcher = new HashSafeClassAndMethodMatcher(new ExactClassMatcher(declaringClass.getName()), new ExactMethodMatcher(methodToInstrument.getName(), Type.getMethodDescriptor(methodToInstrument)));
        boolean shouldRetransform = ServiceFactory.getClassTransformerService().addTraceMatcher(matcher, metricPrefix);
        if (shouldRetransform) {
            this.logger.log(Level.FINE, "Retransforming {0} for instrumentation.", new Object[]{methodToInstrument});
            PeriodicRetransformer.INSTANCE.queueRetransform(declaringClass);
        }
    }

    public void retransformUninstrumentedClass(Class<?> classToRetransform) {
        if (!classToRetransform.isAnnotationPresent(InstrumentedClass.class)) {
            this.retransformClass(classToRetransform);
        } else {
            this.logger.log(Level.FINER, "Class ", new Object[]{classToRetransform, " already instrumented."});
        }
    }

    private void retransformClass(Class<?> classToRetransform) {
        try {
            ServiceFactory.getAgent().getInstrumentation().retransformClasses(classToRetransform);
        }
        catch (UnmodifiableClassException e) {
            this.logger.log(Level.FINE, "Unable to retransform class ", new Object[]{classToRetransform, " : ", e.getMessage()});
        }
    }

    public Class<?> loadClass(ClassLoader classLoader, Class<?> theClass) throws ClassNotFoundException {
        this.logger.log(Level.FINE, "Loading class ", new Object[]{theClass.getName(), " using class loader ", classLoader.toString()});
        try {
            return classLoader.loadClass(theClass.getName());
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.FINEST, "Unable to load", new Object[]{theClass.getName(), ".  Appending it to the classloader."});
            WeaveInstrumentation weaveInstrumentation = theClass.getAnnotation(WeaveInstrumentation.class);
            if (weaveInstrumentation != null) {
                this.logger.log(Level.FINE, theClass.getName(), new Object[]{" is defined in ", weaveInstrumentation.title(), " version ", weaveInstrumentation.version()});
                try {
                    ServiceFactory.getClassTransformerService().getContextManager().getClassWeaverService().loadClass(classLoader, weaveInstrumentation.title(), theClass.getName());
                    return classLoader.loadClass(theClass.getName());
                }
                catch (Exception e2) {
                    throw new ClassNotFoundException("Unable to load " + theClass.getName() + " from instrumentation package " + weaveInstrumentation.title());
                }
            }
            throw new ClassNotFoundException("Unable to load " + theClass.getName());
        }
    }

    public com.newrelic.agent.bridge.Transaction getTransaction() {
        Transaction innerTx = Transaction.getTransaction();
        if (innerTx != null) {
            return new TransactionApiImpl();
        }
        return NoOpTransaction.INSTANCE;
    }

    public int addToObjectCache(Object object) {
        return this.objectCache.add(object);
    }

    public Object getCachedObject(int id) {
        return this.objectCache.get(id);
    }

    public boolean isWeaveClass(Class<?> clazz) {
        return this.weaveClasses.contains(Type.getType(clazz));
    }

    public void addWeaveClass(Type type) {
        this.weaveClasses.add(type);
    }

    public void registerCloseable(String instrumentationName, Closeable closeable) {
        if (instrumentationName != null && closeable != null) {
            ServiceFactory.getClassTransformerService().getContextManager().getClassWeaverService().registerInstrumentationCloseable(instrumentationName, closeable);
        }
    }
}

