/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.context;

import com.newrelic.agent.Agent;
import com.newrelic.agent.InstrumentationProxy;
import com.newrelic.agent.config.ClassTransformerConfig;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableSet;
import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.com.google.common.collect.MapMaker;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.objectweb.asm.AnnotationVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.ClassWriter;
import com.newrelic.agent.deps.org.objectweb.asm.Label;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.AdviceAdapter;
import com.newrelic.agent.instrumentation.MethodBuilder;
import com.newrelic.agent.instrumentation.classmatchers.ChildClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.DefaultClassAndMethodMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OptimizedClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OptimizedClassMatcherBuilder;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.context.ContextClassTransformer;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.instrumentation.context.InstrumentationContextManager;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.OrMethodMatcher;
import com.newrelic.agent.instrumentation.tracing.BridgeUtils;
import com.newrelic.agent.service.ServiceFactory;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassLoaderClassTransformer
implements ContextClassTransformer {
    public static final String NEWRELIC_CLASS_PREFIX = "com.newrelic.agent.";
    private static final String NEWRELIC_API_CLASS_PREFIX = "com.newrelic.api.agent.";
    private static final Type CLASSLOADER_TYPE = Type.getType(ClassLoader.class);
    private static final com.newrelic.agent.deps.org.objectweb.asm.commons.Method LOAD_CLASS_METHOD = new com.newrelic.agent.deps.org.objectweb.asm.commons.Method("loadClass", Type.getType(Class.class), new Type[]{Type.getType(String.class)});
    private static final com.newrelic.agent.deps.org.objectweb.asm.commons.Method LOAD_CLASS_RESOLVE_METHOD = new com.newrelic.agent.deps.org.objectweb.asm.commons.Method("loadClass", Type.getType(Class.class), new Type[]{Type.getType(String.class), Type.getType(Boolean.TYPE)});
    private static final Set<com.newrelic.agent.deps.org.objectweb.asm.commons.Method> METHODS = ImmutableSet.of(LOAD_CLASS_METHOD, LOAD_CLASS_RESOLVE_METHOD);
    private static final com.newrelic.agent.deps.org.objectweb.asm.commons.Method CHECK_PACKAGE_ACCESS_METHOD = new com.newrelic.agent.deps.org.objectweb.asm.commons.Method("checkPackageAccess", Type.VOID_TYPE, new Type[]{Type.getType(Class.class), Type.getType(ProtectionDomain.class)});
    private final Set<ClassLoader> safeClassLoaders = Sets.newSetFromMap(new MapMaker().weakKeys().makeMap());
    private final Set<ClassLoader> unsafeClassLoaders = Sets.newSetFromMap(new MapMaker().weakKeys().makeMap());
    private final ClassMatchVisitorFactory matcher;
    private final Set<String> classloadersToSkip;

    public ClassLoaderClassTransformer(InstrumentationContextManager manager) {
        OptimizedClassMatcherBuilder matcherBuilder = OptimizedClassMatcherBuilder.newBuilder();
        matcherBuilder.addClassMethodMatcher(new DefaultClassAndMethodMatcher(new ChildClassMatcher(CLASSLOADER_TYPE.getInternalName(), false), OrMethodMatcher.getMethodMatcher(new ExactMethodMatcher(LOAD_CLASS_METHOD.getName(), LOAD_CLASS_METHOD.getDescriptor()), new ExactMethodMatcher(LOAD_CLASS_RESOLVE_METHOD.getName(), LOAD_CLASS_RESOLVE_METHOD.getDescriptor()))));
        this.matcher = matcherBuilder.build();
        manager.addContextClassTransformer(this.matcher, this);
        String agentClassloaderName = Type.getType(Agent.getClassLoader().getClass()).getInternalName();
        this.classloadersToSkip = ImmutableSet.of("com/ibm/oti/vm/BootstrapClassLoader", agentClassloaderName);
    }

    void start(Instrumentation instrumentation) {
        ArrayList<Class> toRetransform = Lists.newArrayList();
        for (Class clazz : instrumentation.getAllLoadedClasses()) {
            if (!ClassLoader.class.isAssignableFrom(clazz) || clazz.getName().startsWith("java.") || clazz.getName().startsWith("sun.") || this.classloadersToSkip.contains(Type.getType(clazz).getInternalName())) continue;
            toRetransform.add(clazz);
        }
        if (!toRetransform.isEmpty()) {
            Agent.LOG.finer("Retransforming " + toRetransform);
            try {
                instrumentation.retransformClasses(toRetransform.toArray(new Class[0]));
            }
            catch (UnmodifiableClassException e) {
                Agent.LOG.log(Level.FINE, "Error retransforming classes", e);
            }
        }
        try {
            InstrumentationProxy.forceRetransformation(instrumentation, ClassLoader.class);
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINE, "Error retransforming " + ClassLoader.class.getName(), e);
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer, InstrumentationContext context, OptimizedClassMatcher.Match match) throws IllegalClassFormatException {
        if (loader == null) {
            return null;
        }
        if (this.classloadersToSkip.contains(className)) {
            return null;
        }
        try {
            if (match.isClassAndMethodMatch()) {
                return this.transformBytes(className, classfileBuffer);
            }
        }
        catch (Exception ex) {
            Agent.LOG.log(Level.FINER, "Unable to modify classloader " + loader.getClass().getName(), ex);
        }
        return null;
    }

    byte[] transformBytes(String className, byte[] classfileBuffer) {
        ClassReader reader = new ClassReader(classfileBuffer);
        ClassWriter writer = new ClassWriter(1);
        reader.accept(new ClassLoaderClassVisitor((ClassVisitor)writer), 8);
        Agent.LOG.finer("Patching classloader " + className);
        return writer.toByteArray();
    }

    public boolean isClassLoaderSafe(ClassLoader loader) {
        if (loader.getClass().getClassLoader() == null || this.safeClassLoaders.contains(loader)) {
            return true;
        }
        if (this.unsafeClassLoaders.contains(loader)) {
            return false;
        }
        try {
            if (!loader.getClass().isAnnotationPresent(ModifiedClassloader.class)) {
                Method method = loader.getClass().getMethod("loadClass", String.class);
                if (method.getClass().equals(loader)) {
                    this.unsafeClassLoaders.add(loader);
                    return false;
                }
                try {
                    method = loader.getClass().getDeclaredMethod("loadClass", String.class, Boolean.TYPE);
                    if (method.getClass().equals(loader)) {
                        this.unsafeClassLoaders.add(loader);
                        return false;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.safeClassLoaders.add(loader);
            return true;
        }
        catch (Exception ex) {
            Agent.LOG.log(Level.FINER, "Unable to verify classloader " + loader.getClass().getName(), ex);
            return false;
        }
    }

    private class ClassLoaderClassVisitor
    extends ClassVisitor {
        Set<com.newrelic.agent.deps.org.objectweb.asm.commons.Method> methods;

        public ClassLoaderClassVisitor(ClassVisitor cv) {
            super(327680, cv);
            this.methods = METHODS;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            AnnotationVisitor visitAnnotation = this.visitAnnotation(Type.getDescriptor(ModifiedClassloader.class), true);
            visitAnnotation.visitEnd();
            if (CLASSLOADER_TYPE.getInternalName().equals(name)) {
                this.methods = ImmutableSet.of(LOAD_CLASS_METHOD);
            }
        }

        public MethodVisitor visitMethod(final int access, String name, String desc, String signature, String[] exceptions) {
            ClassTransformerConfig config;
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            com.newrelic.agent.deps.org.objectweb.asm.commons.Method method = new com.newrelic.agent.deps.org.objectweb.asm.commons.Method(name, desc);
            if (this.methods.contains(method)) {
                mv = new AdviceAdapter(327680, mv, access, name, desc){
                    Label startFinallyLabel;

                    protected void onMethodEnter() {
                        this.startFinallyLabel = this.newLabel();
                        this.loadArg(0);
                        this.mv.visitLdcInsn(ClassLoaderClassTransformer.NEWRELIC_API_CLASS_PREFIX);
                        this.mv.visitMethodInsn(182, "java/lang/String", "startsWith", "(Ljava/lang/String;)Z", false);
                        this.mv.visitJumpInsn(153, this.startFinallyLabel);
                        this.loadNewRelicClass();
                        this.visitLabel(this.startFinallyLabel);
                    }

                    public void visitMaxs(int maxStack, int maxLocals) {
                        Label endFinallyLabel = new Label();
                        super.visitTryCatchBlock(this.startFinallyLabel, endFinallyLabel, endFinallyLabel, Type.getType(ClassNotFoundException.class).getInternalName());
                        super.visitLabel(endFinallyLabel);
                        this.onMethodExit(191);
                        super.visitMaxs(maxStack, maxLocals);
                    }

                    protected void onMethodExit(int opcode) {
                        if (opcode == 191) {
                            this.loadArg(0);
                            this.mv.visitLdcInsn(ClassLoaderClassTransformer.NEWRELIC_CLASS_PREFIX);
                            this.mv.visitMethodInsn(182, "java/lang/String", "startsWith", "(Ljava/lang/String;)Z", false);
                            Label skip = this.newLabel();
                            this.mv.visitJumpInsn(153, skip);
                            this.loadNewRelicClass();
                            this.mv.visitLabel(skip);
                            this.mv.visitInsn(191);
                        }
                    }

                    private void loadNewRelicClass() {
                        MethodBuilder methodBuilder = new MethodBuilder(this, access);
                        methodBuilder.loadInvocationHandlerFromProxy();
                        this.mv.visitLdcInsn("CLASSLOADER");
                        this.mv.visitInsn(1);
                        this.mv.visitInsn(1);
                        methodBuilder.invokeInvocationHandlerInterface(false);
                        this.checkCast(Type.getType(ClassLoader.class));
                        Label isNRClassLoader = this.newLabel();
                        this.dup();
                        this.loadThis();
                        this.ifCmp(CLASSLOADER_TYPE, 153, isNRClassLoader);
                        this.loadArg(0);
                        this.mv.visitMethodInsn(182, "java/lang/ClassLoader", LOAD_CLASS_METHOD.getName(), LOAD_CLASS_METHOD.getDescriptor(), false);
                        this.mv.visitInsn(176);
                        this.mv.visitLabel(isNRClassLoader);
                        this.pop();
                    }
                };
            } else if (CHECK_PACKAGE_ACCESS_METHOD.equals(method) && System.getSecurityManager() != null && (config = ServiceFactory.getConfigService().getDefaultAgentConfig().getClassTransformerConfig()).isGrantPackageAccess()) {
                mv = new AdviceAdapter(327680, mv, access, name, desc){

                    protected void onMethodEnter() {
                        this.getStatic(BridgeUtils.AGENT_BRIDGE_TYPE, "instrumentation", BridgeUtils.INSTRUMENTATION_TYPE);
                        this.loadArg(0);
                        this.invokeInterface(BridgeUtils.INSTRUMENTATION_TYPE, new com.newrelic.agent.deps.org.objectweb.asm.commons.Method("isWeaveClass", Type.BOOLEAN_TYPE, new Type[]{Type.getType(Class.class)}));
                        Label skip = this.newLabel();
                        this.ifZCmp(153, skip);
                        this.visitInsn(177);
                        this.visitLabel(skip);
                        super.onMethodEnter();
                    }
                };
            }
            return mv;
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ModifiedClassloader {
    }
}

