/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.context;

import com.newrelic.agent.bridge.AsyncApi;
import com.newrelic.agent.bridge.Instrumentation;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.AdviceAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.tracing.BridgeUtils;
import com.newrelic.agent.util.asm.BytecodeGenProxyBuilder;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurrentTransactionRewriter {
    public static ClassVisitor rewriteCurrentTransactionReferences(ClassVisitor cv, ClassReader reader) {
        final Set<Method> localTransactionMethods = CurrentTransactionRewriter.getLocalTransactionMethods(reader);
        if (localTransactionMethods.isEmpty()) {
            return cv;
        }
        return new ClassVisitor(327680, cv){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                if (localTransactionMethods.contains(new Method(name, desc))) {
                    mv = new RewriteVisitor(mv, access, name, desc);
                }
                return mv;
            }
        };
    }

    private static boolean isCurrentTransactionReference(int opcode, String owner, String name) {
        return 178 == opcode && BridgeUtils.isTransactionType(owner) && "CURRENT".equals(name);
    }

    private static boolean isCurrentTransactionMethod(String owner, String name) {
        return BridgeUtils.isAgentType(owner) && "getTransaction".equals(name);
    }

    private static boolean isAsyncApiMethod(String owner, String name) {
        return Type.getInternalName(AsyncApi.class).equals(owner) && "resumeAsync".equals(name);
    }

    private static Set<Method> getLocalTransactionMethods(ClassReader reader) {
        final HashSet<Method> methods = Sets.newHashSet();
        ClassVisitor cv = new ClassVisitor(327680){

            public MethodVisitor visitMethod(int access, final String methodName, final String methodDesc, String signature, String[] exceptions) {
                return new MethodVisitor(327680){

                    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                        if (CurrentTransactionRewriter.isCurrentTransactionReference(opcode, owner, name)) {
                            methods.add(new Method(methodName, methodDesc));
                        }
                    }

                    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                        super.visitMethodInsn(opcode, owner, name, desc, itf);
                        if (CurrentTransactionRewriter.isAsyncApiMethod(owner, name) || CurrentTransactionRewriter.isCurrentTransactionMethod(owner, name)) {
                            methods.add(new Method(methodName, methodDesc));
                        }
                    }
                };
            }
        };
        reader.accept(cv, 6);
        return methods;
    }

    private static class RewriteVisitor
    extends AdviceAdapter {
        final int transactionLocal = this.newLocal(BridgeUtils.TRANSACTION_TYPE);

        protected RewriteVisitor(MethodVisitor mv, int access, String name, String desc) {
            super(327680, mv, access, name, desc);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (CurrentTransactionRewriter.isCurrentTransactionReference(opcode, owner, name)) {
                this.loadLocal(this.transactionLocal);
            } else {
                super.visitFieldInsn(opcode, owner, name, desc);
            }
        }

        protected void onMethodEnter() {
            super.onMethodEnter();
            this.getStatic(BridgeUtils.AGENT_BRIDGE_TYPE, "instrumentation", BridgeUtils.INSTRUMENTATION_TYPE);
            BytecodeGenProxyBuilder.newBuilder(Instrumentation.class, this, false).build().getTransaction();
            this.storeLocal(this.transactionLocal, BridgeUtils.TRANSACTION_TYPE);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (CurrentTransactionRewriter.isCurrentTransactionMethod(owner, name)) {
                this.pop();
                this.loadLocal(this.transactionLocal);
            } else {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
                if (CurrentTransactionRewriter.isAsyncApiMethod(owner, name)) {
                    this.dup();
                    this.storeLocal(this.transactionLocal);
                }
            }
        }
    }
}

