/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.custom;

import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.instrumentation.context.InstrumentationContextManager;
import com.newrelic.agent.instrumentation.custom.CustomClassTransformer;
import com.newrelic.agent.instrumentation.custom.ExtensionClassAndMethodMatcher;
import com.newrelic.agent.service.ServiceFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassRetransformer {
    private final InstrumentationContextManager contextManager;
    private CustomClassTransformer transformer;

    public ClassRetransformer(InstrumentationContextManager contextManager) {
        this.contextManager = contextManager;
    }

    public synchronized Set<Class<?>> setClassMethodMatchers(List<ExtensionClassAndMethodMatcher> newMatchers) {
        Class[] allLoadedClasses = ServiceFactory.getAgent().getInstrumentation().getAllLoadedClasses();
        HashSet<ClassMatchVisitorFactory> matchers = Sets.newHashSet();
        if (this.transformer != null) {
            matchers.add(this.transformer.getMatcher());
            this.transformer.destroy();
        }
        if (newMatchers.isEmpty()) {
            this.transformer = null;
        } else {
            this.transformer = new CustomClassTransformer(this.contextManager, newMatchers);
            matchers.add(this.transformer.getMatcher());
        }
        Set<Class<?>> toRetransform = InstrumentationContext.getMatchingClasses(matchers, allLoadedClasses);
        return toRetransform;
    }

    public synchronized Set<Class<?>> appendClassMethodMatchers(List<ExtensionClassAndMethodMatcher> toAdd) {
        if (this.transformer != null) {
            toAdd.addAll(this.transformer.extensionPointCuts);
        }
        return this.setClassMethodMatchers(toAdd);
    }
}

