/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.methodmatchers;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationMethodMatcher
implements MethodMatcher {
    private final Type annotationType;
    private final String annotationDesc;

    public AnnotationMethodMatcher(Type annotationType) {
        this.annotationType = annotationType;
        this.annotationDesc = annotationType.getDescriptor();
    }

    @Override
    public boolean matches(int access, String name, String desc, Set<String> annotations) {
        if (annotations == MethodMatcher.UNSPECIFIED_ANNOTATIONS) {
            Agent.LOG.finer("The annotation method matcher will not work if annotations aren't specified");
        }
        return annotations.contains(this.annotationDesc);
    }

    @Override
    public Method[] getExactMethods() {
        return null;
    }

    public Type getAnnotationType() {
        return this.annotationType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annotationDesc == null ? 0 : this.annotationDesc.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotationMethodMatcher other = (AnnotationMethodMatcher)obj;
        return !(this.annotationType == null ? other.annotationType != null : !this.annotationType.equals(other.annotationType));
    }
}

