/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.methodmatchers;

import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ManyMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OrMethodMatcher
extends ManyMethodMatcher {
    private OrMethodMatcher(MethodMatcher ... methodMatchers) {
        super(methodMatchers);
    }

    private OrMethodMatcher(Collection<MethodMatcher> methodMatchers) {
        super(methodMatchers);
    }

    @Override
    public boolean matches(int access, String name, String desc, Set<String> annotations) {
        for (MethodMatcher matcher : this.methodMatchers) {
            if (!matcher.matches(access, name, desc, annotations)) continue;
            return true;
        }
        return false;
    }

    public static final MethodMatcher getMethodMatcher(MethodMatcher ... matchers) {
        return OrMethodMatcher.getMethodMatcher(Arrays.asList(matchers));
    }

    public static final MethodMatcher getMethodMatcher(Collection<MethodMatcher> matchers) {
        if (matchers.size() == 1) {
            return matchers.iterator().next();
        }
        HashMap<String, DescMethodMatcher> exactMatchers = new HashMap<String, DescMethodMatcher>();
        LinkedList<MethodMatcher> otherMatchers = new LinkedList<MethodMatcher>();
        for (MethodMatcher matcher : matchers) {
            if (matcher instanceof ExactMethodMatcher) {
                ExactMethodMatcher m = (ExactMethodMatcher)matcher;
                if (m.getDescriptions().isEmpty()) {
                    otherMatchers.add(matcher);
                    continue;
                }
                DescMethodMatcher descMatcher = (DescMethodMatcher)exactMatchers.get(m.getName());
                if (descMatcher == null) {
                    descMatcher = new DescMethodMatcher(m.getDescriptions());
                    exactMatchers.put(m.getName().intern(), descMatcher);
                    continue;
                }
                descMatcher.addDescriptions(m.getDescriptions());
                continue;
            }
            otherMatchers.add(matcher);
        }
        OrExactMethodMatchers matcher = new OrExactMethodMatchers(exactMatchers);
        if (otherMatchers.size() == 0) {
            return matcher;
        }
        otherMatchers.add(matcher);
        return new OrMethodMatcher(otherMatchers);
    }

    public String toString() {
        return "Or Match " + this.methodMatchers;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DescMethodMatcher
    implements MethodMatcher {
        private Set<String> descriptions;

        public DescMethodMatcher(Set<String> set) {
            this.descriptions = new HashSet<String>(set);
        }

        public void addDescriptions(Set<String> desc) {
            this.descriptions.addAll(desc);
        }

        @Override
        public boolean matches(int access, String name, String desc, Set<String> annotations) {
            return this.descriptions.contains(desc);
        }

        public String toString() {
            return this.descriptions.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.descriptions == null ? 0 : this.descriptions.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DescMethodMatcher other = (DescMethodMatcher)obj;
            return !(this.descriptions == null ? other.descriptions != null : !this.descriptions.equals(other.descriptions));
        }

        @Override
        public Method[] getExactMethods() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OrExactMethodMatchers
    implements MethodMatcher {
        private final Map<String, DescMethodMatcher> exactMatchers;

        public OrExactMethodMatchers(Map<String, DescMethodMatcher> exactMatchers) {
            this.exactMatchers = exactMatchers;
        }

        @Override
        public boolean matches(int access, String name, String desc, Set<String> annotations) {
            DescMethodMatcher matcher = this.exactMatchers.get(name);
            if (matcher == null) {
                return false;
            }
            return matcher.matches(access, name, desc, annotations);
        }

        public String toString() {
            return this.exactMatchers.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.exactMatchers == null ? 0 : this.exactMatchers.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OrExactMethodMatchers other = (OrExactMethodMatchers)obj;
            return !(this.exactMatchers == null ? other.exactMatchers != null : !this.exactMatchers.equals(other.exactMatchers));
        }

        @Override
        public Method[] getExactMethods() {
            ArrayList<Method> methods = Lists.newArrayList();
            for (Map.Entry<String, DescMethodMatcher> entry : this.exactMatchers.entrySet()) {
                for (String desc : entry.getValue().descriptions) {
                    methods.add(new Method(entry.getKey(), desc));
                }
            }
            return methods.toArray(new Method[methods.size()]);
        }
    }
}

