/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.asynchttp;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.FieldAccessor;
import com.newrelic.agent.instrumentation.InterfaceMixin;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.InterfaceMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.NameMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.scala.ScalaTracerHolder;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.EntryInvocationHandler;
import com.newrelic.agent.tracers.PointCutInvocationHandler;
import java.net.MalformedURLException;
import java.net.URL;

@com.newrelic.agent.instrumentation.pointcuts.PointCut
public class AsyncHttpClientRequestPointCut
extends PointCut
implements EntryInvocationHandler {
    public static final boolean DEFAULT_ENABLED = true;
    private static final String POINT_CUT_NAME = AsyncHttpClientRequestPointCut.class.getName();

    public AsyncHttpClientRequestPointCut(ClassTransformer classTransformer) {
        super(AsyncHttpClientRequestPointCut.createPointCutConfig(), AsyncHttpClientRequestPointCut.createClassMatcher(), AsyncHttpClientRequestPointCut.createMethodMatcher());
    }

    private static PointCutConfiguration createPointCutConfig() {
        return new PointCutConfiguration(POINT_CUT_NAME, "play2_instrumentation", true);
    }

    private static ClassMatcher createClassMatcher() {
        return new InterfaceMatcher("com/ning/http/client/AsyncHttpProvider");
    }

    private static MethodMatcher createMethodMatcher() {
        return new NameMethodMatcher("execute");
    }

    protected PointCutInvocationHandler getPointCutInvocationHandlerImpl() {
        return this;
    }

    public void handleInvocation(ClassMethodSignature sig, Object object, Object[] args) {
        if (!Transaction.hasTransaction()) {
            return;
        }
        Request request = null;
        if (!(args[0] instanceof Request)) {
            return;
        }
        request = (Request)args[0];
        ScalaTracerHolder tracerHolder = null;
        if (args[1] instanceof AsyncHandler) {
            Object elem;
            Object oref = ((AsyncHandler)args[1])._nr_objectRef();
            if (oref instanceof ObjectRef && (elem = ((ObjectRef)oref)._nr_element()) instanceof ScalaTracerHolder) {
                tracerHolder = (ScalaTracerHolder)elem;
            }
        } else if (args[1] instanceof JavaAsyncHandler) {
            tracerHolder = (ScalaTracerHolder)((JavaAsyncHandler)args[1])._nr_scalaPromise();
        } else {
            return;
        }
        Transaction tx = Transaction.getTransaction();
        URL url = null;
        try {
            url = new URL(request.getUrl());
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (tracerHolder != null) {
            AsyncHttpClientTracerInfo tracerInfo = new AsyncHttpClientTracerInfo(sig, url == null ? "URL_PARSE_ERROR" : url.getHost(), request.getUrl(), request.getMethod());
            tracerHolder._nr_setTracer(tracerInfo);
        }
    }

    @InterfaceMixin(originalClassName={"scala/runtime/ObjectRef"})
    public static interface ObjectRef {
        public static final String CLASS = "scala/runtime/ObjectRef";

        @FieldAccessor(fieldName="elem", existingField=true)
        public Object _nr_element();
    }

    @InterfaceMixin(originalClassName={"play.api.libs.ws.WS$WSRequest$$anon$1", "play.api.libs.ws.ning.NingWSRequest$$anon$1"})
    public static interface AsyncHandler {
        public static final String SCALA_CLASS = "play.api.libs.ws.WS$WSRequest$$anon$1";
        public static final String SCALA_CLASS_2_3 = "play.api.libs.ws.ning.NingWSRequest$$anon$1";

        @FieldAccessor(fieldName="result$1", fieldDesc="Lscala/runtime/ObjectRef;", existingField=true)
        public Object _nr_objectRef();
    }

    @InterfaceMixin(originalClassName={"play.libs.WS$WSRequest$1", "play.libs.ws.ning.NingWSRequest$1"})
    public static interface JavaAsyncHandler {
        public static final String CLASS = "play.libs.WS$WSRequest$1";
        public static final String CLASS_2_3 = "play.libs.ws.ning.NingWSRequest$1";

        @FieldAccessor(fieldName="val$scalaPromise", fieldDesc="Lscala/concurrent/Promise;", existingField=true)
        public Object _nr_scalaPromise();
    }

    @InterfaceMixin(originalClassName={"com/ning/http/client/Request"})
    public static interface Request {
        public static final String INTERFACE = "com/ning/http/client/Request";

        public String getMethod();

        public String getUrl();
    }

    public static final class AsyncHttpClientTracerInfo {
        private final long startTime = System.nanoTime();
        private final ClassMethodSignature sig;
        private final String host;
        private final String uri;
        private final String methodName;

        public AsyncHttpClientTracerInfo(ClassMethodSignature sig, String host, String uri, String methodName) {
            this.sig = sig;
            this.host = host;
            this.uri = uri;
            this.methodName = methodName;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public ClassMethodSignature getClassMethodSignature() {
            return this.sig;
        }

        public String getHost() {
            return this.host;
        }

        public String getUri() {
            return this.uri;
        }

        public String getMethodName() {
            return this.methodName;
        }
    }
}

