/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.resin;

import com.newrelic.agent.Agent;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.jmx.values.ResinJmxValues;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.EntryInvocationHandler;
import com.newrelic.agent.tracers.PointCutInvocationHandler;
import java.util.logging.Level;

@com.newrelic.agent.instrumentation.pointcuts.PointCut
public class ResinStartupPointCut
extends PointCut
implements EntryInvocationHandler {
    public static final String RESIN_INSTRUMENTATION_GROUP_NAME = "resin_instrumentation";
    private boolean addJmx = false;

    public ResinStartupPointCut(ClassTransformer classTransformer) {
        super(new PointCutConfiguration(ResinStartupPointCut.class.getName(), RESIN_INSTRUMENTATION_GROUP_NAME, true), new ExactClassMatcher("com.caucho.server.resin/Resin"), ResinStartupPointCut.createExactMethodMatcher("start", "()V"));
    }

    public void handleInvocation(ClassMethodSignature sig, Object object, Object[] args) {
        if (!this.addJmx) {
            ServiceFactory.getJmxService().addJmxFrameworkValues(new ResinJmxValues());
            this.addJmx = true;
            if (Agent.LOG.isFinerEnabled()) {
                Agent.LOG.log(Level.FINER, "Added JMX for Resin");
            }
        }
    }

    protected PointCutInvocationHandler getPointCutInvocationHandlerImpl() {
        return this;
    }
}

