/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.database;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.database.DatabaseVendor;
import com.newrelic.agent.deps.com.google.common.cache.Cache;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.InterfaceMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.database.ConnectionExtension;
import com.newrelic.agent.instrumentation.pointcuts.database.ConnectionFactory;
import com.newrelic.agent.instrumentation.pointcuts.database.DatabaseUtils;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DatabaseTracer;
import com.newrelic.agent.tracers.MethodExitTracer;
import com.newrelic.agent.tracers.Tracer;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

@PointCut
public class SqlDriverPointCut
extends TracerFactoryPointCut {
    public SqlDriverPointCut(ClassTransformer classTransformer) {
        super(new PointCutConfiguration("jdbc_driver"), (ClassMatcher)new InterfaceMatcher("java/sql/Driver"), SqlDriverPointCut.createExactMethodMatcher("connect", "(Ljava/lang/String;Ljava/util/Properties;)Ljava/sql/Connection;"));
    }

    public static final void putConnectionFactory(Transaction tx, Connection connection, ConnectionFactory factory) {
        Connection innerConnection = DatabaseUtils.getInnerConnection(connection);
        if (innerConnection instanceof ConnectionExtension && ((ConnectionExtension)((Object)innerConnection))._nr_getConnectionFactory() != null) {
            return;
        }
        if (Agent.isDebugEnabled()) {
            Agent.LOG.finer("Tracking connection: " + connection.getClass().getName());
        }
        if (connection instanceof ConnectionExtension) {
            ((ConnectionExtension)((Object)connection))._nr_setConnectionFactory(factory);
            return;
        }
        if (factory.getDatabaseVendor().isExplainPlanSupported() && tx.getTransactionTracerConfig().isEnabled() && tx.getTransactionTracerConfig().isExplainEnabled()) {
            tx.getConnectionCache().putConnectionFactory(connection, factory);
        }
    }

    protected boolean isDispatcher() {
        return true;
    }

    public static ConnectionFactory getConnectionFactory(Transaction transaction, Connection connection) {
        ConnectionFactory factory;
        if ((connection = DatabaseUtils.getInnerConnection(connection)) instanceof ConnectionExtension && (factory = ((ConnectionExtension)((Object)connection))._nr_getConnectionFactory()) != null) {
            return factory;
        }
        Cache<Connection, ConnectionFactory> connections = transaction.getConnectionCache().getConnectionFactoryCache();
        if (connections == null) {
            return null;
        }
        ConnectionFactory connectionFactory = connections.getIfPresent(connection);
        if (connectionFactory == null) {
            if (connections.size() == 1L) {
                return (ConnectionFactory)connections.asMap().values().iterator().next();
            }
            if (connections.size() < 100L) {
                for (Map.Entry entry : connections.asMap().entrySet()) {
                    if (!connection.equals(entry.getKey()) && !((Connection)entry.getKey()).equals(connection)) continue;
                    connections.put(connection, (ConnectionFactory)entry.getValue());
                    return (ConnectionFactory)entry.getValue();
                }
            }
        }
        return connectionFactory;
    }

    public Tracer getTracer(Transaction tx, ClassMethodSignature sig, Object driver, Object[] args) {
        return tx.getTransactionCounts().isOverTracerSegmentLimit() ? null : new ConnectionTracer(tx, sig, driver, args);
    }

    private static class DriverConnectionFactory
    implements ConnectionFactory {
        private static final Properties EMPTY_PROPERTIES = new Properties();
        private final Driver driver;
        private final String url;
        private final Properties props;
        private DatabaseVendor databaseVendor = DatabaseVendor.UNKNOWN;

        public DriverConnectionFactory(Driver driver, String url, Properties props) {
            this.driver = driver;
            this.url = url;
            this.props = props == null || props.isEmpty() ? EMPTY_PROPERTIES : props;
        }

        public Connection getConnection() throws SQLException {
            try {
                return this.driver.connect(this.url, this.props);
            }
            catch (SQLException e) {
                this.logError();
                throw e;
            }
            catch (Exception e) {
                this.logError();
                throw new SQLException(e);
            }
        }

        private void logError() {
            if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.finer(MessageFormat.format("An error occurred getting a database connection. Driver:{0} url:{1}", this.driver, this.url));
            }
        }

        public String getUrl() {
            return this.url;
        }

        public DatabaseVendor getDatabaseVendor() {
            return this.databaseVendor;
        }

        void setDatabaseVendor(DatabaseVendor databaseVendor) {
            this.databaseVendor = databaseVendor;
        }
    }

    private static class ConnectionTracer
    extends ConnectionErrorTracer {
        private final DriverConnectionFactory connectionFactory;

        public ConnectionTracer(Transaction transaction, ClassMethodSignature sig, Object driver, Object[] args) {
            super(sig, transaction);
            this.connectionFactory = new DriverConnectionFactory((Driver)driver, (String)args[0], (Properties)args[1]);
        }

        protected void doFinish(int opcode, Object connection) {
            super.doFinish(opcode, connection);
            if (connection != null) {
                this.connectionFactory.setDatabaseVendor(DatabaseUtils.getDatabaseVendor((Connection)connection));
                SqlDriverPointCut.putConnectionFactory(this.getTransaction(), (Connection)connection, this.connectionFactory);
            }
        }
    }

    private static class ConnectionErrorTracer
    extends MethodExitTracer
    implements DatabaseTracer {
        public ConnectionErrorTracer(ClassMethodSignature signature, Transaction transaction) {
            super(signature, transaction);
        }

        public void finish(Throwable throwable) {
            super.finish(throwable);
            this.getTransactionActivity().getTransactionStats().getUnscopedStats().getStats("DatabaseErrors/all").incrementCallCount();
        }

        protected void doFinish(int opcode, Object returnValue) {
        }
    }
}

