/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.solr;

import com.newrelic.agent.Agent;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.jmx.values.SolrJmxValues;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.EntryInvocationHandler;
import com.newrelic.agent.tracers.PointCutInvocationHandler;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.Manifest;
import java.util.logging.Level;

@com.newrelic.agent.instrumentation.pointcuts.PointCut
public class SolrCorePointCut
extends PointCut
implements EntryInvocationHandler {
    private static final String POINT_CUT_NAME = SolrCorePointCut.class.getName();
    private static final boolean DEFAULT_ENABLED = true;
    private static final String SOLR_CORE_CLASS = "org/apache/solr/core/SolrCore";
    private static final String INIT_INDEX_METHOD_NAME = "initIndex";
    private static final String INIT_INDEX_METHOD_DESC = "()V";
    private static final String INIT_INDEX_METHOD_4_0_DESC = "(Z)V";
    private final AtomicBoolean addJmx = new AtomicBoolean(false);

    public SolrCorePointCut(ClassTransformer classTransformer) {
        super(SolrCorePointCut.createPointCutConfig(), SolrCorePointCut.createClassMatcher(), SolrCorePointCut.createMethodMatcher());
    }

    private static PointCutConfiguration createPointCutConfig() {
        return new PointCutConfiguration(POINT_CUT_NAME, null, true);
    }

    private static ClassMatcher createClassMatcher() {
        return new ExactClassMatcher(SOLR_CORE_CLASS);
    }

    private static MethodMatcher createMethodMatcher() {
        return new ExactMethodMatcher(INIT_INDEX_METHOD_NAME, INIT_INDEX_METHOD_DESC, INIT_INDEX_METHOD_4_0_DESC);
    }

    protected PointCutInvocationHandler getPointCutInvocationHandlerImpl() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleInvocation(ClassMethodSignature sig, Object core, Object[] args) {
        String version = null;
        try {
            InputStream iStream = core.getClass().getClassLoader().getResourceAsStream("META-INF/MANIFEST.MF");
            try {
                Manifest manifest = new Manifest(iStream);
                version = manifest.getMainAttributes().getValue("Specification-Version");
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                iStream.close();
                throw throwable;
            }
            iStream.close();
            {
            }
        }
        catch (Exception e) {
            Agent.LOG.fine("Unable to determine the Solr version : " + e.toString());
        }
        try {
            version = version == null ? this.getVersion(core) : version;
        }
        catch (Exception e) {
            version = "1.0";
        }
        ServiceFactory.getEnvironmentService().getEnvironment().addSolrVersion(version);
        this.addJmxConfig();
    }

    private void addJmxConfig() {
        try {
            if (!this.addJmx.getAndSet(true)) {
                ServiceFactory.getJmxService().addJmxFrameworkValues(new SolrJmxValues());
                if (Agent.LOG.isFinerEnabled()) {
                    Agent.LOG.log(Level.FINER, "Added JMX for Solr");
                }
            }
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Unable to add Solr JMX metrics: {0}", e.toString());
            Agent.LOG.severe(msg);
        }
    }

    private Object getVersion(Object core) throws Exception {
        return core.getClass().getMethod("getVersion", new Class[0]).invoke(core, new Object[0]);
    }
}

