/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.weaver;

import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.AdviceAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.tracing.BridgeUtils;
import com.newrelic.agent.instrumentation.weaver.InstrumentationPackage;
import com.newrelic.agent.util.Strings;
import com.newrelic.api.agent.Logger;
import java.util.logging.Level;

public class LogApiCallsVisitor
extends ClassVisitor {
    private final InstrumentationPackage instrumentationPackage;
    private String className;

    public LogApiCallsVisitor(InstrumentationPackage instrumentationPackage, ClassVisitor cv) {
        super(327680, cv);
        this.instrumentationPackage = instrumentationPackage;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.className = name;
    }

    public MethodVisitor visitMethod(final int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        final Method method = new Method(name, desc);
        return new AdviceAdapter(327680, mv, access, name, desc){

            @Override
            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
                this.logApiCall(method, access, owner, name, desc, AgentBridge.API_CLASSES);
            }

            private boolean logApiCall(Method instrumentationMethod, int access2, String owner, String name, String desc, Class<?> ... apiClasses) {
                for (Class<?> apiClass : apiClasses) {
                    Type apiType = Type.getType(apiClass);
                    if (!apiType.getInternalName().equals(owner)) continue;
                    String logMessage = Strings.join(LogApiCallsVisitor.this.className, ".", instrumentationMethod.toString(), " called ", apiType.getClassName(), ".", new Method(name, desc).toString());
                    Logger logger = BridgeUtils.getLogger(this);
                    logger.logToChild(LogApiCallsVisitor.this.instrumentationPackage.getImplementationTitle(), Level.FINEST, logMessage, (Object[])null);
                    return true;
                }
                return false;
            }
        };
    }
}

