/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.weaver;

import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.FieldVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.weaver.InvalidReferenceException;
import com.newrelic.agent.instrumentation.weaver.WeavedClassInfo;
import com.newrelic.agent.logging.IAgentLogger;
import com.newrelic.api.agent.weaver.MatchType;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReferencesVisitor
extends ClassVisitor {
    private String className;
    private final Map<String, Set<Method>> referencedClassMethods;
    private final Map<String, Set<Method>> referencedInterfaceMethods;
    private final WeavedClassInfo weaveDetails;
    private final IAgentLogger logger;

    public ReferencesVisitor(IAgentLogger logger, WeavedClassInfo weaveDetails, ClassVisitor classVisitor, Map<String, Set<Method>> referencedClasses, Map<String, Set<Method>> referencedInterfaces) {
        super(327680, classVisitor);
        this.weaveDetails = weaveDetails;
        this.referencedClassMethods = referencedClasses;
        this.referencedInterfaceMethods = referencedInterfaces;
        this.logger = logger;
    }

    public MatchType getMatchType() {
        return this.weaveDetails == null ? null : this.weaveDetails.getMatchType();
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        this.addClassReference(Type.getObjectType(name), null);
        if (null != superName) {
            this.addClassReference(Type.getObjectType(superName), null);
        }
        for (String interfaceName : interfaces) {
            this.addInterfaceReference(Type.getObjectType(interfaceName), null);
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        this.addClassReference(Type.getType(desc), null);
        return super.visitField(access, name, desc, signature, value);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        boolean isAbstract;
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        Method method = new Method(name, desc);
        this.addClassReference(method.getReturnType(), null);
        for (Type argType : method.getArgumentTypes()) {
            this.addClassReference(argType, null);
        }
        boolean bl = isAbstract = (0x400 & access) != 0;
        if (this.weaveDetails != null && (this.weaveDetails.getWeavedMethods().contains(method) || isAbstract)) {
            if (MatchType.Interface.equals((Object)this.getMatchType())) {
                this.addInterfaceReference(Type.getObjectType(this.className), method);
            } else {
                this.addClassReference(Type.getObjectType(this.className), method);
            }
        }
        if (isAbstract) {
            return mv;
        }
        final boolean synthetic = (0x1000 & access) != 0;
        mv = new MethodVisitor(327680, mv){

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (synthetic) {
                    ReferencesVisitor.this.logger.warning(ReferencesVisitor.this.className + " references a synthetic method to access " + owner + "." + name + desc + ".  This will not work correctly in instrumented classes.");
                }
                if (!(ReferencesVisitor.this.className.equals(owner) || (opcode & 0xB7) != 0 && name.equals("<init>") && desc.equals("()V"))) {
                    Method method = new Method(name, desc);
                    if (185 == opcode) {
                        ReferencesVisitor.this.addInterfaceReference(Type.getObjectType(owner), method);
                    } else {
                        ReferencesVisitor.this.addClassReference(Type.getObjectType(owner), method);
                    }
                }
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }

            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                super.visitFieldInsn(opcode, owner, name, desc);
            }
        };
        return mv;
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        for (Map.Entry<String, Set<Method>> entry : this.referencedInterfaceMethods.entrySet()) {
            Set<Method> methods = this.referencedClassMethods.remove(entry.getKey());
            if (methods == null || methods.isEmpty()) continue;
            throw new InvalidReferenceException(entry.getKey() + " is referenced as a class when invoking methods " + methods + ", but as an interface when invoking methods " + entry.getValue());
        }
    }

    private void addClassReference(Type type, Method method) {
        ReferencesVisitor.addReference(type, method, this.referencedClassMethods);
    }

    private void addInterfaceReference(Type type, Method method) {
        ReferencesVisitor.addReference(type, method, this.referencedInterfaceMethods);
    }

    private static void addReference(Type type, Method method, Map<String, Set<Method>> references) {
        if (type.getSort() != 10) {
            if (type.getSort() == 9) {
                ReferencesVisitor.addReference(type.getElementType(), method, references);
                return;
            }
            return;
        }
        String internalName = type.getInternalName();
        if (internalName != null) {
            Set<Method> referencedMethods = references.get(internalName);
            if (referencedMethods == null) {
                referencedMethods = Sets.newHashSet();
                references.put(internalName, referencedMethods);
            }
            if (method != null) {
                referencedMethods.add(method);
            }
        }
    }
}

