/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.weaver;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.com.google.common.base.Predicate;
import com.newrelic.agent.deps.com.google.common.cache.Cache;
import com.newrelic.agent.deps.com.google.common.cache.CacheBuilder;
import com.newrelic.agent.deps.com.google.common.cache.CacheLoader;
import com.newrelic.agent.deps.com.google.common.cache.LoadingCache;
import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.deps.org.objectweb.asm.tree.FieldNode;
import com.newrelic.agent.instrumentation.weaver.AgentClassStructureResolver;
import com.newrelic.agent.instrumentation.weaver.ClassAppender;
import com.newrelic.agent.instrumentation.weaver.ClassStructureResolver;
import com.newrelic.agent.instrumentation.weaver.InstrumentationPackage;
import com.newrelic.agent.instrumentation.weaver.WeavedClassInfo;
import com.newrelic.agent.logging.IAgentLogger;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsService;
import com.newrelic.agent.stats.StatsWorks;
import com.newrelic.agent.util.ClassUtils;
import com.newrelic.agent.util.asm.ClassStructure;
import com.newrelic.agent.util.asm.Utils;
import com.newrelic.api.agent.Logger;
import com.newrelic.api.agent.weaver.Weave;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Verifier {
    private volatile Map<String, Set<Method>> referencedClassMethods;
    private volatile Map<String, Set<Method>> referencedInterfaceMethods;
    private final Cache<ClassLoader, Boolean> classLoaders;
    private final Map<Type, ClassStructure> resolvedClasses;
    private final LoadingCache<ClassLoader, AtomicInteger> classLoaderLocks;
    private final InstrumentationPackage instrumentationPackage;
    private final ClassStructureResolver classStructureResolver;
    private static final int CLASS_STRUCTURE_FLAGS = 7;

    public Verifier(InstrumentationPackage instrumentationPackage) throws NoSuchMethodException, SecurityException {
        this(instrumentationPackage, new AgentClassStructureResolver());
    }

    public Verifier(InstrumentationPackage instrumentationPackage, ClassStructureResolver classStructureResolver) throws NoSuchMethodException, SecurityException {
        this.instrumentationPackage = instrumentationPackage;
        this.classStructureResolver = classStructureResolver;
        this.referencedClassMethods = Collections.emptyMap();
        this.referencedInterfaceMethods = Collections.emptyMap();
        this.classLoaders = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(5L, TimeUnit.MINUTES).build();
        this.classLoaderLocks = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(1L, TimeUnit.MINUTES).build(new CacheLoader<ClassLoader, AtomicInteger>(){

            @Override
            public AtomicInteger load(ClassLoader key) throws Exception {
                return new AtomicInteger();
            }
        });
        this.resolvedClasses = Maps.newConcurrentMap();
    }

    public Map<Type, ClassStructure> getResolvedClasses() {
        return Collections.unmodifiableMap(this.resolvedClasses);
    }

    public String getImplementationTitle() {
        return this.instrumentationPackage.getImplementationTitle();
    }

    public boolean isEnabled(ClassLoader loader) {
        Boolean enabled = this.classLoaders.getIfPresent(loader);
        return enabled == null || enabled != false;
    }

    public boolean isVerified(ClassLoader loader) {
        Boolean verified = this.isVerifiedObject(loader);
        return verified != null && verified != false;
    }

    private Boolean isVerifiedObject(ClassLoader loader) {
        return this.classLoaders.getIfPresent(loader);
    }

    public boolean verify(ClassAppender classAppender, ClassLoader loader, Map<String, byte[]> classesInNewJar) {
        Boolean verified = this.isVerifiedObject(loader);
        if (verified != null) {
            return verified;
        }
        verified = this.doVerify(classAppender, loader, classesInNewJar);
        if (verified == null) {
            return this.isVerified(loader);
        }
        this.classLoaders.put(loader, verified);
        if (verified.booleanValue()) {
            this.instrumentationPackage.getLogger().debug("Loading " + this.getImplementationTitle() + " instrumentation");
        }
        StatsService statsService = ServiceFactory.getStatsService();
        statsService.doStatsWork(StatsWorks.getRecordMetricWork(MessageFormat.format(verified != false ? "Supportability/WeaveInstrumentation/Loaded/{0}/{1}" : "Supportability/WeaveInstrumentation/Skipped/{0}/{1}", this.getImplementationTitle(), Float.valueOf(this.instrumentationPackage.getImplementationVersion())), 1.0f));
        return verified;
    }

    private static void resolve(IAgentLogger logger, ClassStructureResolver classStructureResolver, Map<String, Set<Method>> allReferenced, ClassLoader loader, Map<String, ClassStructure> resolvedClasses, Set<String> unresolvedClasses, boolean isInterface) {
        for (Map.Entry<String, Set<Method>> entry : allReferenced.entrySet()) {
            String internalName = entry.getKey();
            ClassStructure classStructure = null;
            try {
                classStructure = classStructureResolver.getClassStructure(logger, loader, internalName, 7);
            }
            catch (IOException e) {
                logger.log(Level.FINEST, e, "Error fetching class structure of {0} : {1}", new Object[]{internalName, e.getMessage()});
            }
            if (classStructure == null) {
                unresolvedClasses.add(internalName);
                continue;
            }
            if (!entry.getValue().isEmpty() && Verifier.isInterface(classStructure.getAccess()) != isInterface) {
                unresolvedClasses.add(internalName);
                logger.finer(internalName + " is referenced as a" + (isInterface ? "n interface" : " class"));
                continue;
            }
            resolvedClasses.put(internalName, classStructure);
        }
    }

    private static boolean isInterface(int access) {
        return (access & 0x200) != 0;
    }

    private Boolean doVerify(ClassAppender classAppender, ClassLoader loader, Map<String, byte[]> classesInNewJar) {
        block12: {
            HashMap<String, ClassStructure> resolvedClasses = Maps.newHashMap();
            HashSet<String> unresolvedClasses = Sets.newHashSet();
            this.resolveWeaveClasses(loader, unresolvedClasses);
            if (!unresolvedClasses.isEmpty()) {
                this.instrumentationPackage.getLogger().finer("Skipping " + this.getImplementationTitle() + " instrumentation.  Unresolved classes: " + unresolvedClasses);
                return false;
            }
            if (!this.instrumentationPackage.skipClasses.isEmpty()) {
                this.instrumentationPackage.getLogger().finest("Checking for the presence of classes: " + this.instrumentationPackage.skipClasses);
            }
            if (this.shouldSkip(loader)) {
                return false;
            }
            Verifier.resolve(this.instrumentationPackage.getLogger(), this.classStructureResolver, this.referencedClassMethods, loader, resolvedClasses, unresolvedClasses, false);
            Verifier.resolve(this.instrumentationPackage.getLogger(), this.classStructureResolver, this.referencedInterfaceMethods, loader, resolvedClasses, unresolvedClasses, true);
            unresolvedClasses.removeAll(resolvedClasses.keySet());
            HashMap<String, Set<Method>> allReferenced = Maps.newHashMap(this.referencedClassMethods);
            allReferenced.putAll(this.referencedInterfaceMethods);
            HashSet<String> set = Sets.newHashSet(unresolvedClasses);
            set.removeAll(classesInNewJar.keySet());
            if (!set.isEmpty()) {
                this.instrumentationPackage.getLogger().finer("Skipping " + this.getImplementationTitle() + " instrumentation.  Unresolved classes: " + set);
                return false;
            }
            for (Map.Entry entry : resolvedClasses.entrySet()) {
                try {
                    Set methods = (Set)allReferenced.get(entry.getKey());
                    if (methods.isEmpty()) continue;
                    this.verifyMethods(loader, methods, (ClassStructure)entry.getValue());
                    if (methods.isEmpty()) continue;
                    this.instrumentationPackage.getLogger().finer("Skipping " + this.getImplementationTitle() + " instrumentation.  " + (String)entry.getKey() + " unresolved methods: " + methods);
                    return false;
                }
                catch (IOException ex) {
                    this.instrumentationPackage.getLogger().log(Level.FINER, "Verifier error", ex);
                }
            }
            HashMap<String, byte[]> copy = Maps.newHashMap(classesInNewJar);
            copy.keySet().retainAll(unresolvedClasses);
            if (!copy.isEmpty()) {
                try {
                    AtomicInteger lockCount = this.classLoaderLocks.get(loader);
                    if (lockCount.getAndIncrement() != 0) break block12;
                    try {
                        this.loadClasses(classAppender, loader, copy);
                    }
                    catch (Exception e) {
                        this.instrumentationPackage.getLogger().log(Level.FINEST, "Error loading unresolved clases: " + copy, e);
                        return null;
                    }
                }
                catch (ExecutionException ex) {
                    Agent.LOG.log(Level.FINEST, ex, ex.toString(), new Object[0]);
                    return this.isVerifiedObject(loader);
                }
            }
        }
        return true;
    }

    private boolean shouldSkip(ClassLoader loader) {
        for (String className : this.instrumentationPackage.skipClasses) {
            ClassStructure classStructure = null;
            try {
                classStructure = this.getClassStructure(this.instrumentationPackage.getLogger(), loader, className);
            }
            catch (IOException e) {
                // empty catch block
            }
            if (classStructure == null) continue;
            this.instrumentationPackage.getLogger().log(Level.FINER, "Skipping weave package because {0} is present", new Object[]{className});
            return true;
        }
        return false;
    }

    private void resolveWeaveClasses(ClassLoader loader, Set<String> unresolvedClasses) {
        for (Map.Entry<String, WeavedClassInfo> entry : this.instrumentationPackage.getWeaveClasses().entrySet()) {
            String internalName = entry.getKey();
            ClassStructure classStructure = null;
            try {
                classStructure = this.getClassStructure(this.instrumentationPackage.getLogger(), loader, internalName);
            }
            catch (IOException e) {
                // empty catch block
            }
            if (classStructure == null || classStructure.getClassAnnotations().containsKey(Type.getDescriptor(Weave.class))) {
                unresolvedClasses.add(internalName);
            }
            Collection<FieldNode> referencedFields = entry.getValue().getReferencedFields();
            for (FieldNode field : referencedFields) {
                FieldNode fieldNode = classStructure.getFields().get(field.name);
                if (fieldNode == null) {
                    unresolvedClasses.add(internalName);
                    this.instrumentationPackage.getLogger().finer("Field " + field.name + " does not exist on " + internalName);
                    continue;
                }
                if (fieldNode.desc.equals(field.desc)) continue;
                this.instrumentationPackage.getLogger().finer("Expected field " + field.name + " on " + internalName + " to have the signature " + field.desc + ", but found " + fieldNode.desc);
            }
        }
    }

    private ClassStructure getClassStructure(Logger logger, ClassLoader loader, String internalName) throws IOException {
        return this.classStructureResolver.getClassStructure(logger, loader, internalName, 7);
    }

    private void verifyMethods(ClassLoader loader, Set<Method> methods, ClassStructure classStructure) throws IOException {
        this.resolvedClasses.put(classStructure.getType(), classStructure);
        methods.removeAll(classStructure.getMethods());
        if (methods.isEmpty()) {
            return;
        }
        for (String interfaceClass : classStructure.getInterfaces()) {
            this.verifyMethods(loader, methods, this.getClassStructure(this.instrumentationPackage.getLogger(), loader, interfaceClass));
            if (!methods.isEmpty()) continue;
            return;
        }
        String superName = classStructure.getSuperName();
        if (superName != null) {
            this.verifyMethods(loader, methods, this.getClassStructure(this.instrumentationPackage.getLogger(), loader, superName));
        }
    }

    private void loadClasses(ClassAppender classAppender, ClassLoader loader, Map<String, byte[]> classBytes) throws IOException {
        ArrayList<String> loadedClasses = Lists.newArrayList();
        for (Map.Entry<String, byte[]> nameAndBytes : classBytes.entrySet()) {
            try {
                Class<?> clazz = loader.loadClass(Type.getObjectType(nameAndBytes.getKey()).getClassName());
                if (clazz.getClassLoader() != null && !clazz.getClassLoader().equals(loader) && !this.isFullyResolveable(loader, clazz, nameAndBytes.getValue(), classBytes.keySet())) continue;
                loadedClasses.add(Type.getInternalName(clazz));
            }
            catch (Exception ex) {}
        }
        if (!loadedClasses.isEmpty()) {
            this.instrumentationPackage.getLogger().finer(this.getImplementationTitle() + " skipping already loaded classes: " + loadedClasses);
            classBytes.keySet().removeAll(loadedClasses);
        }
        if (!classBytes.isEmpty()) {
            this.instrumentationPackage.getLogger().finer(this.getImplementationTitle() + " loading classes: " + classBytes.keySet() + " using class loader " + loader);
            classAppender.appendClasses(loader, classBytes);
        }
    }

    private boolean isFullyResolveable(ClassLoader loader, Class<?> clazz, byte[] classBytes, Set<String> newClassNames) {
        Set<String> referencedClasses = ClassUtils.getClassReferences(classBytes);
        referencedClasses.removeAll(newClassNames);
        referencedClasses = Sets.filter(referencedClasses, new Predicate<String>(){

            @Override
            public boolean apply(String internalClassName) {
                return !internalClassName.startsWith("java/");
            }
        });
        for (String internalClassName : referencedClasses) {
            try {
                Class<?> throughClassLoader;
                String className = Type.getObjectType(internalClassName).getClassName();
                Class<?> throughLoader = loader.loadClass(className);
                if (throughLoader == (throughClassLoader = clazz.getClassLoader().loadClass(className)) || throughLoader.isAssignableFrom(throughClassLoader) && throughClassLoader.isAssignableFrom(throughLoader)) continue;
                this.instrumentationPackage.getLogger().log(Level.FINEST, "{0} was resolved through class loader {1}, but it references {2} and the version of that class loaded through {3} differs from the one loaded through {4}", new Object[]{clazz.getName(), clazz.getClassLoader(), className, loader, throughClassLoader.getClassLoader()});
                return false;
            }
            catch (ClassNotFoundException e) {
            }
        }
        return true;
    }

    public ClassStructure getClassStructure(Type type) {
        ClassStructure classStructure = this.getResolvedClasses().get(type);
        if (classStructure == null) {
            for (Map.Entry entry : this.classLoaders.asMap().entrySet()) {
                URL resource;
                if (!((Boolean)entry.getValue()).booleanValue() || (resource = ((ClassLoader)entry.getKey()).getResource(Utils.getClassResourceName(type.getInternalName()))) == null) continue;
                try {
                    classStructure = ClassStructure.getClassStructure(resource);
                }
                catch (IOException e) {
                    this.instrumentationPackage.getLogger().finest("Unable to load structure of " + type.getClassName());
                }
            }
        }
        return classStructure;
    }

    void setReferences(Map<String, Set<Method>> referencedClassMethods, Map<String, Set<Method>> referencedInterfaceMethods) {
        this.referencedClassMethods = Collections.unmodifiableMap(referencedClassMethods);
        this.referencedInterfaceMethods = Collections.unmodifiableMap(referencedInterfaceMethods);
    }
}

