/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.webservices;

import com.newrelic.agent.Agent;
import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.deps.com.google.common.base.Function;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableMap;
import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.org.objectweb.asm.AnnotationVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.classmatchers.DefaultClassAndMethodMatcher;
import com.newrelic.agent.instrumentation.classmatchers.InterfaceMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OptimizedClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OptimizedClassMatcherBuilder;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.context.ContextClassTransformer;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.instrumentation.context.InstrumentationContextManager;
import com.newrelic.agent.instrumentation.context.TraceDetailsList;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.OrMethodMatcher;
import com.newrelic.agent.instrumentation.tracing.InstrumentationType;
import com.newrelic.agent.instrumentation.tracing.TraceDetails;
import com.newrelic.agent.instrumentation.tracing.TraceDetailsBuilder;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.util.Strings;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestAnnotationVisitor {
    private static final String PATH_DESCRIPTOR = Type.getObjectType("javax/ws/rs/Path").getDescriptor();
    private static final Map<String, String> OPERATION_DESCRIPTORS = RestAnnotationVisitor.getHttpMethods();

    public final ClassMatchVisitorFactory getClassMatchVisitorFactory() {
        return new ClassMatchVisitorFactory(){

            @Override
            public ClassVisitor newClassMatchVisitor(ClassLoader loader, Class<?> classBeingRedefined, ClassReader reader, ClassVisitor cv, InstrumentationContext context) {
                return RestAnnotationVisitor.createClassVisitor(reader.getClassName(), cv, context);
            }
        };
    }

    public final ClassMatchVisitorFactory getInterfaceMatchVisitorFactory(final InstrumentationContextManager instrumentationContextManager) {
        final Pattern classMatcherPattern = this.getClassMatcherPattern();
        Agent.LOG.log(Level.FINEST, "REST interface matcher pattern: {0}", new Object[]{classMatcherPattern.pattern()});
        return new ClassMatchVisitorFactory(){

            @Override
            public ClassVisitor newClassMatchVisitor(ClassLoader loader, Class<?> classBeingRedefined, final ClassReader reader, ClassVisitor cv, InstrumentationContext context) {
                if (!classMatcherPattern.matcher(reader.getClassName()).matches()) {
                    return cv;
                }
                final TraceList list = new TraceList();
                return new ClassVisitor(327680, RestAnnotationVisitor.createClassVisitor(reader.getClassName(), cv, list)){

                    public void visitEnd() {
                        super.visitEnd();
                        if (list.methodToDetails != null) {
                            ArrayList<MethodMatcher> methodMatchers = Lists.newArrayList();
                            for (Method method : list.methodToDetails.keySet()) {
                                methodMatchers.add(new ExactMethodMatcher(method.getName(), method.getDescriptor()));
                            }
                            DefaultClassAndMethodMatcher matcher = new DefaultClassAndMethodMatcher(new InterfaceMatcher(reader.getClassName()), OrMethodMatcher.getMethodMatcher(methodMatchers));
                            ClassMatchVisitorFactory classMatcher = OptimizedClassMatcherBuilder.newBuilder().addClassMethodMatcher(matcher).build();
                            InterfaceImplementationMatcher interfaceMatcher = new InterfaceImplementationMatcher(reader.getClassName(), list.methodToDetails);
                            instrumentationContextManager.addContextClassTransformer(classMatcher, interfaceMatcher);
                            this.reloadMatchingClasses(classMatcher);
                        }
                    }

                    private void reloadMatchingClasses(ClassMatchVisitorFactory classMatcher) {
                        ServiceFactory.getClassTransformerService().retransformMatchingClasses(Arrays.asList(classMatcher));
                    }
                };
            }
        };
    }

    private Pattern getClassMatcherPattern() {
        try {
            List<String> matchers = (List<String>)ServiceFactory.getConfigService().getDefaultAgentConfig().getValue("instrumentation.rest_annotations.class_filter", Arrays.asList("com.*"));
            matchers = Lists.transform(matchers, new Function<String, String>(){

                @Override
                public String apply(String input) {
                    return input.replace('.', '/');
                }
            });
            return Strings.getPatternFromGlobs(matchers);
        }
        catch (Exception ex) {
            return Pattern.compile("^com/.*");
        }
    }

    public static ClassVisitor createClassVisitor(final String internalClassName, ClassVisitor cv, final TraceDetailsList context) {
        return new ClassVisitor(327680, cv){
            String rootPath;

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                if (PATH_DESCRIPTOR.equals(desc)) {
                    return new AnnotationVisitor(327680, super.visitAnnotation(desc, visible)){

                        public void visit(String name, Object value) {
                            if ("value".equals(name)) {
                                rootPath = (String)value;
                            }
                            super.visit(name, value);
                        }
                    };
                }
                return super.visitAnnotation(desc, visible);
            }

            public MethodVisitor visitMethod(int access, final String methodName, final String methodDesc, String signature, String[] exceptions) {
                return new MethodVisitor(327680, super.visitMethod(access, methodName, methodDesc, signature, exceptions)){
                    String methodPath;
                    String httpMethod;

                    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                        String theHttpMethod = (String)OPERATION_DESCRIPTORS.get(desc);
                        if (theHttpMethod != null) {
                            this.httpMethod = theHttpMethod;
                        } else if (PATH_DESCRIPTOR.equals(desc)) {
                            return new AnnotationVisitor(327680, super.visitAnnotation(desc, visible)){

                                public void visit(String name, Object value) {
                                    if ("value".equals(name)) {
                                        methodPath = (String)value;
                                    }
                                    super.visit(name, value);
                                }
                            };
                        }
                        return super.visitAnnotation(desc, visible);
                    }

                    public void visitEnd() {
                        if (this.httpMethod != null) {
                            TraceDetailsBuilder builder = TraceDetailsBuilder.newBuilder().setInstrumentationType(InstrumentationType.BuiltIn).setInstrumentationSourceName(RestAnnotationVisitor.class.getName()).setDispatcher(true);
                            if (rootPath == null && this.methodPath == null) {
                                builder.setTransactionName(TransactionNamePriority.FRAMEWORK_HIGH, false, "RestWebService", Type.getObjectType(internalClassName).getClassName() + "/" + methodName);
                            } else {
                                String fullPath = RestAnnotationVisitor.getPath(rootPath, this.methodPath, this.httpMethod);
                                builder.setTransactionName(TransactionNamePriority.FRAMEWORK_HIGH, false, "RestWebService", fullPath);
                            }
                            context.addTrace(new Method(methodName, methodDesc), builder.build());
                        }
                        super.visitEnd();
                    }
                };
            }
        };
    }

    static String getPath(String rootPath, String methodPath, String httpMethod) {
        StringBuilder fullPath = new StringBuilder();
        if (rootPath != null) {
            if (rootPath.endsWith("/")) {
                fullPath.append(rootPath.substring(0, rootPath.length() - 1));
            } else {
                fullPath.append(rootPath);
            }
        }
        if (methodPath != null) {
            if (!methodPath.startsWith("/")) {
                fullPath.append('/');
            }
            if (methodPath.endsWith("/")) {
                fullPath.append(methodPath.substring(0, methodPath.length() - 1));
            } else {
                fullPath.append(methodPath);
            }
        }
        fullPath.append(" (").append(httpMethod).append(')');
        return fullPath.toString();
    }

    private static Map<String, String> getHttpMethods() {
        HashMap<String, String> methods = Maps.newHashMap();
        for (String httpMethod : Arrays.asList("PUT", "POST", "GET", "DELETE", "HEAD", "OPTIONS")) {
            methods.put(Type.getObjectType("javax/ws/rs/" + httpMethod).getDescriptor(), httpMethod);
        }
        return ImmutableMap.copyOf(methods);
    }

    private static class TraceList
    implements TraceDetailsList {
        Map<Method, TraceDetails> methodToDetails;

        private TraceList() {
        }

        public void addTrace(Method method, TraceDetails traceDetails) {
            if (this.methodToDetails == null) {
                this.methodToDetails = Maps.newHashMap();
            }
            this.methodToDetails.put(method, traceDetails);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class InterfaceImplementationMatcher
    implements ContextClassTransformer {
        private final Map<Method, TraceDetails> methodToDetails;
        private final String interfaceName;

        public InterfaceImplementationMatcher(String className, Map<Method, TraceDetails> methodToDetails) {
            this.interfaceName = className;
            this.methodToDetails = methodToDetails;
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer, InstrumentationContext context, OptimizedClassMatcher.Match match) throws IllegalClassFormatException {
            Agent.LOG.log(Level.FINEST, "REST annotation match for interface {0}, class {1}", new Object[]{this.interfaceName, className});
            context.addTracedMethods(this.methodToDetails);
            return null;
        }
    }
}

