/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.platform;

import com.newrelic.agent.Agent;
import com.newrelic.agent.platform.UnregisteredThreadFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractPlatformCommand<T> {
    private final String command;
    private final String[] args;
    static final int SUBPROCESS_UNSPECIFIED_ERROR = 3;
    static final int SUBPROCESS_NOT_DONE = -1;
    private volatile int exitCode = -1;

    AbstractPlatformCommand(String command, String[] args) {
        this.command = command;
        this.args = args;
    }

    abstract T getValue();

    void beforeChildStart() {
    }

    abstract void processChildLine(String var1);

    void afterChildEnd() {
    }

    int getExitCode() {
        return this.exitCode;
    }

    boolean isDone() {
        return this.exitCode != -1;
    }

    void execute() {
        ArrayList<String> list = new ArrayList<String>(1 + this.args.length);
        list.add(this.command);
        list.addAll(Arrays.asList(this.args));
        Agent.LOG.fine("Execute " + list);
        try {
            UnregisteredThreadFactory threadFactory = new UnregisteredThreadFactory("New Relic Stream Reader", true);
            ProcessBuilder pb = new ProcessBuilder(list);
            Process subproc = pb.start();
            ChildErrorStreamReader errRunnable = new ChildErrorStreamReader(subproc.getErrorStream());
            Thread subprocErr = threadFactory.newThread(errRunnable);
            subprocErr.start();
            ChildInputStreamReader outRunnable = new ChildInputStreamReader(subproc.getInputStream());
            Thread subprocOut = threadFactory.newThread(outRunnable);
            subprocOut.start();
            subprocErr.join();
            subprocOut.join();
            this.exitCode = subproc.waitFor();
            Agent.LOG.fine("Execution of " + list + " returned code " + this.exitCode);
        }
        catch (Exception e) {
            Agent.LOG.info("Subprocess execution failed. This is not necessarily an error condition.");
            if (Agent.LOG.isFinestEnabled()) {
                Agent.LOG.log(Level.FINEST, "Exception while running subprocess to get number of physical cores", e);
            }
            this.exitCode = 3;
        }
    }

    private class ChildInputStreamReader
    extends AsyncReader {
        ChildInputStreamReader(InputStream stream) {
            super(stream);
        }

        void beforeStart() {
            AbstractPlatformCommand.this.beforeChildStart();
        }

        void processLine(String line) {
            AbstractPlatformCommand.this.processChildLine(line);
        }

        void afterEnd() {
            AbstractPlatformCommand.this.afterChildEnd();
        }
    }

    private static class ChildErrorStreamReader
    extends AsyncReader {
        ChildErrorStreamReader(InputStream stream) {
            super(stream);
        }

        public void processLine(String line) {
            if (Agent.LOG.isFinestEnabled()) {
                Agent.LOG.finest("child stderr> " + line);
            }
        }

        public void beforeStart() {
            if (Agent.LOG.isFinestEnabled()) {
                Agent.LOG.finest("Stderr from child command follows:");
            }
        }

        public void afterEnd() {
            if (Agent.LOG.isFinestEnabled()) {
                Agent.LOG.finest("End of stderr from child.");
            }
        }
    }

    private static abstract class AsyncReader
    implements Runnable {
        private final InputStream stream;

        AsyncReader(InputStream stream) {
            this.stream = stream;
        }

        abstract void beforeStart();

        abstract void processLine(String var1);

        abstract void afterEnd();

        private static void close(Reader sr) {
            try {
                sr.close();
            }
            catch (IOException e) {
                Agent.LOG.finest("Exception while closing Reader: " + sr + ": " + e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            BufferedReader br;
            block9: {
                InputStreamReader isr = null;
                br = null;
                try {
                    try {
                        String line;
                        isr = new InputStreamReader(this.stream);
                        br = new BufferedReader(isr);
                        this.beforeStart();
                        while ((line = br.readLine()) != null) {
                            this.processLine(line);
                        }
                        this.afterEnd();
                    }
                    catch (Exception e) {
                        Agent.LOG.fine("Exception while reading stream from child process");
                        if (Agent.LOG.isFinestEnabled()) {
                            Agent.LOG.log(Level.FINEST, "while reading child stream", e);
                        }
                        Object var5_6 = null;
                        if (isr != null) {
                            AsyncReader.close(isr);
                        }
                        if (br == null) return;
                        AsyncReader.close(br);
                        return;
                    }
                    Object var5_5 = null;
                    if (isr == null) break block9;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    if (isr != null) {
                        AsyncReader.close(isr);
                    }
                    if (br == null) throw throwable;
                    AsyncReader.close(br);
                    throw throwable;
                }
                AsyncReader.close(isr);
            }
            if (br == null) return;
            AsyncReader.close(br);
        }
    }
}

