/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.platform;

import com.newrelic.agent.Agent;
import com.newrelic.agent.platform.AbstractPlatformCommand;
import java.text.MessageFormat;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SolarisPhysicalCoreCountCommand
extends AbstractPlatformCommand<Integer> {
    private static final String[] ARGS = new String[]{"-p"};
    private volatile Integer result = null;
    private boolean isFirstLine = true;

    SolarisPhysicalCoreCountCommand() {
        super("/usr/sbin/psrinfo", ARGS);
    }

    @Override
    Integer getValue() {
        return this.result;
    }

    @Override
    void processChildLine(String line) {
        block6: {
            try {
                if (line != null && !line.isEmpty()) {
                    if (this.isFirstLine) {
                        this.result = Integer.valueOf(line);
                        this.isFirstLine = false;
                    } else if (Agent.LOG.isFinerEnabled()) {
                        Agent.LOG.log(Level.FINER, MessageFormat.format("There is an unexpected line in the SunOS physical core command result: {0}", line));
                    }
                }
            }
            catch (Exception e) {
                Agent.LOG.log(Level.FINER, MessageFormat.format("Unable the retrieve the SunOs physical core count. Line: {0}. ", line));
                if (!Agent.LOG.isFinestEnabled()) break block6;
                Agent.LOG.log(Level.FINEST, "An error occured parsing the SunOs physical core count command result. ", e);
            }
        }
    }
}

