/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.platform;

import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.platform.AbstractPlatformInspector;
import com.newrelic.agent.platform.AsyncCommandRunner;
import com.newrelic.agent.platform.DefaultPhysicalMemoryProvider;
import com.newrelic.agent.platform.SolarisPhysicalCoreCountCommand;
import java.io.File;
import java.util.concurrent.ExecutorService;

class SolarisPlatformInspector
extends AbstractPlatformInspector {
    static final String COMMAND = "/usr/sbin/psrinfo";
    private final AsyncCommandRunner<Integer> coreCountRunner;

    SolarisPlatformInspector(ExecutorService executor) {
        this.coreCountRunner = new AsyncCommandRunner<Integer>(new SolarisPhysicalCoreCountCommand(), executor);
    }

    boolean recognizesPlatform() {
        return new File(COMMAND).exists();
    }

    void start(AgentConfig config) {
        this.coreCountRunner.start();
    }

    boolean isDone() {
        return this.coreCountRunner.isDone();
    }

    Integer getPhysicalCoreCount() {
        Integer result = null;
        if (this.coreCountRunner.getCommand().getExitCode() != -1) {
            result = this.coreCountRunner.getCommand().getValue();
        }
        return result;
    }

    Float getPhysicalMemoryInMB() {
        return DefaultPhysicalMemoryProvider.getPhysicalMemoryInMB();
    }
}

