/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile;

import com.newrelic.agent.Agent;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.TransactionListener;
import com.newrelic.agent.deps.org.json.simple.JSONStreamAware;
import com.newrelic.agent.profile.IProfile;
import com.newrelic.agent.profile.Profile;
import com.newrelic.agent.profile.ProfileTree;
import com.newrelic.agent.profile.ProfilerParameters;
import com.newrelic.agent.profile.ThreadType;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.TransactionStats;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyTransactionProfile
implements IProfile,
TransactionListener,
JSONStreamAware {
    private static final int CAPACITY = 100;
    private static final long THREAD_CHECK_INTERVAL_IN_NANOS = TimeUnit.NANOSECONDS.convert(300L, TimeUnit.SECONDS);
    private final IProfile delegate;
    private final String keyTransaction;
    private final Map<Long, Queue<StackTraceHolder>> pendingStackTraces = new ConcurrentHashMap<Long, Queue<StackTraceHolder>>();
    private final Queue<StackTraceHolder> releasedStackTraces = new ConcurrentLinkedQueue<StackTraceHolder>();
    private long lastThreadCheck = System.nanoTime();
    private final Set<Long> requestThreads = new HashSet<Long>();

    public KeyTransactionProfile(ProfilerParameters parameters) {
        this.keyTransaction = parameters.getKeyTransaction();
        this.delegate = new Profile(parameters);
    }

    IProfile getDelegate() {
        return this.delegate;
    }

    @Override
    public void start() {
        ServiceFactory.getTransactionService().addTransactionListener(this);
        this.delegate.start();
    }

    @Override
    public void end() {
        ServiceFactory.getTransactionService().removeTransactionListener(this);
        this.pendingStackTraces.clear();
        this.releaseStackTraces();
        this.delegate.end();
    }

    @Override
    public ProfilerParameters getProfilerParameters() {
        return this.delegate.getProfilerParameters();
    }

    @Override
    public int getSampleCount() {
        return this.delegate.getSampleCount();
    }

    @Override
    public Long getProfileId() {
        return this.delegate.getProfileId();
    }

    @Override
    public ProfileTree getProfileTree(ThreadType threadType) {
        return this.delegate.getProfileTree(threadType);
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        this.delegate.writeJSONString(out);
    }

    @Override
    public int trimBy(int count) {
        return this.delegate.trimBy(count);
    }

    @Override
    public long getStartTimeMillis() {
        return this.delegate.getStartTimeMillis();
    }

    @Override
    public long getEndTimeMillis() {
        return this.delegate.getEndTimeMillis();
    }

    private void releaseStackTraces() {
        StackTraceHolder holder;
        while ((holder = this.releasedStackTraces.poll()) != null) {
            this.delegate.addStackTrace(holder.getThreadId(), holder.isRunnable(), holder.getType(), holder.getStackTrace());
        }
        return;
    }

    @Override
    public void dispatcherTransactionFinished(TransactionData td, TransactionStats stats) {
        try {
            this.doDispatcherTransactionFinished(td, stats);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Error releasing stack traces for \"{0}\": {1}", td.getBlameMetricName(), e);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, e);
            }
            Agent.LOG.finer(msg);
        }
    }

    private void doDispatcherTransactionFinished(TransactionData td, TransactionStats stats) {
        StackTraceHolder holder;
        Queue<StackTraceHolder> holderQueue = this.getHolderQueue(td.getThreadId());
        if (holderQueue == null) {
            return;
        }
        boolean isKeyTransaction = this.isKeyTransaction(td);
        while ((holder = holderQueue.poll()) != null) {
            if (td.getStartTimeInNanos() > holder.getStackTraceTime()) continue;
            if (td.getEndTimeInNanos() < holder.getStackTraceTime()) break;
            if (!isKeyTransaction) continue;
            this.releasedStackTraces.add(holder);
        }
    }

    private boolean isKeyTransaction(TransactionData td) {
        return this.keyTransaction.equals(td.getBlameMetricName());
    }

    @Override
    public void beforeSampling() {
        this.checkDeadThreads();
        this.releaseStackTraces();
        this.delegate.beforeSampling();
    }

    private void checkDeadThreads() {
        long currentTime = System.nanoTime();
        if (currentTime - this.lastThreadCheck > THREAD_CHECK_INTERVAL_IN_NANOS) {
            this.lastThreadCheck = currentTime;
            Set<Long> liveRequestThreads = ServiceFactory.getThreadService().getRequestThreadIds();
            ArrayList<Long> deadRequestThreads = new ArrayList<Long>(this.requestThreads);
            deadRequestThreads.removeAll(liveRequestThreads);
            for (Long threadId : deadRequestThreads) {
                this.removeHolderQueue(threadId);
            }
        }
    }

    @Override
    public void addStackTrace(long threadId, boolean runnable, ThreadType type, StackTraceElement ... stackTrace) {
        if (type != ThreadType.BasicThreadType.REQUEST) {
            return;
        }
        StackTraceHolder holder = new StackTraceHolder(threadId, runnable, type, stackTrace);
        Queue<StackTraceHolder> holderQueue = this.getOrCreateHolderQueue(threadId);
        holderQueue.offer(holder);
    }

    private Queue<StackTraceHolder> getHolderQueue(long threadId) {
        return this.pendingStackTraces.get(threadId);
    }

    private Queue<StackTraceHolder> getOrCreateHolderQueue(long threadId) {
        Queue<StackTraceHolder> holderQueue = this.pendingStackTraces.get(threadId);
        if (holderQueue == null) {
            holderQueue = new LinkedBlockingQueue<StackTraceHolder>(100);
            this.pendingStackTraces.put(threadId, holderQueue);
            this.requestThreads.add(threadId);
        }
        return holderQueue;
    }

    private void removeHolderQueue(long threadId) {
        this.pendingStackTraces.remove(threadId);
        this.requestThreads.remove(threadId);
    }

    @Override
    public void markInstrumentedMethods() {
    }

    private static class StackTraceHolder {
        private final long threadId;
        private final boolean runnable;
        private final ThreadType type;
        private final long stackTraceTime;
        private final StackTraceElement[] stackTrace;

        private StackTraceHolder(long threadId, boolean runnable, ThreadType type, StackTraceElement ... stackTrace) {
            this.threadId = threadId;
            this.runnable = runnable;
            this.type = type;
            this.stackTrace = stackTrace;
            this.stackTraceTime = System.nanoTime();
        }

        public long getThreadId() {
            return this.threadId;
        }

        public boolean isRunnable() {
            return this.runnable;
        }

        public ThreadType getType() {
            return this.type;
        }

        public StackTraceElement[] getStackTrace() {
            return this.stackTrace;
        }

        public long getStackTraceTime() {
            return this.stackTraceTime;
        }
    }
}

