/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile;

import com.newrelic.agent.Agent;
import com.newrelic.agent.profile.IProfile;
import com.newrelic.agent.profile.RunnableThreadRules;
import com.newrelic.agent.profile.ThreadType;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.util.StackTraces;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileSampler {
    public static final int MAX_STACK_DEPTH = 300;
    private static final ThreadInfo[] EMPTY_THREAD_INFO_ARRAY = new ThreadInfo[0];

    public void sampleStackTraces(List<IProfile> profiles) {
        if (profiles.isEmpty()) {
            return;
        }
        Set<Long> runningThreadIds = this.getRunningThreadIds();
        Set<Long> requestThreadIds = this.getRequestThreadIds(runningThreadIds);
        ThreadInfo[] requestThreadInfos = null;
        for (IProfile profile : profiles) {
            profile.beforeSampling();
            if (profile.getProfilerParameters().isOnlyRequestThreads()) {
                if (requestThreadInfos == null) {
                    requestThreadInfos = this.getRequestThreadInfos(requestThreadIds);
                }
                this.addRequestInfos(profile, requestThreadInfos);
                continue;
            }
            this.addThreadInfos(profile, runningThreadIds, requestThreadIds, this.getAllThreadInfos());
        }
    }

    private void addRequestInfos(IProfile profile, ThreadInfo[] threadInfos) {
        RunnableThreadRules runnableThreadRules = new RunnableThreadRules();
        for (ThreadInfo threadInfo : threadInfos) {
            if (threadInfo == null) continue;
            boolean isRunnable = runnableThreadRules.isRunnable(threadInfo);
            profile.addStackTrace(threadInfo.getThreadId(), isRunnable, ThreadType.BasicThreadType.REQUEST, threadInfo.getStackTrace());
        }
    }

    private void addThreadInfos(IProfile profiler, Set<Long> runningThreadIds, Set<Long> requestThreadIds, ThreadInfo[] threadInfos) {
        if (threadInfos.length == 0) {
            return;
        }
        Set<Long> backgroundThreadIds = this.getBackgroundThreadIds(runningThreadIds);
        Set<Long> agentThreadIds = ServiceFactory.getThreadService().getAgentThreadIds();
        RunnableThreadRules runnableThreadRules = new RunnableThreadRules();
        for (ThreadInfo threadInfo : threadInfos) {
            boolean isRunnable;
            if (threadInfo == null || !(isRunnable = runnableThreadRules.isRunnable(threadInfo)) && profiler.getProfilerParameters().isRunnablesOnly()) continue;
            long threadId = threadInfo.getThreadId();
            ThreadType.BasicThreadType type = agentThreadIds.contains(threadId) ? ThreadType.BasicThreadType.AGENT : (profiler.getProfilerParameters().isProfileAgentThreads() && StackTraces.isInAgentInstrumentation(threadInfo.getStackTrace()) ? ThreadType.BasicThreadType.AGENT_INSTRUMENTATION : (requestThreadIds.contains(threadId) ? ThreadType.BasicThreadType.REQUEST : (backgroundThreadIds.contains(threadId) ? ThreadType.BasicThreadType.BACKGROUND : ThreadType.BasicThreadType.OTHER)));
            profiler.addStackTrace(threadId, isRunnable, type, threadInfo.getStackTrace());
        }
    }

    private Set<Long> getRunningThreadIds() {
        return ServiceFactory.getTransactionService().getRunningThreadIds();
    }

    private Set<Long> getRequestThreadIds(Set<Long> runningThreadIds) {
        HashSet<Long> result = new HashSet<Long>(ServiceFactory.getThreadService().getRequestThreadIds());
        result.retainAll(runningThreadIds);
        return result;
    }

    private Set<Long> getBackgroundThreadIds(Set<Long> runningThreadIds) {
        HashSet<Long> result = new HashSet<Long>(ServiceFactory.getThreadService().getBackgroundThreadIds());
        result.retainAll(runningThreadIds);
        return result;
    }

    private ThreadInfo[] getAllThreadInfos() {
        long[] threadIds = this.getAllThreadIds();
        if (threadIds == null || threadIds.length == 0) {
            return EMPTY_THREAD_INFO_ARRAY;
        }
        HashSet<Long> ids = new HashSet<Long>(threadIds.length);
        for (long threadId : threadIds) {
            ids.add(threadId);
        }
        ids.remove(Thread.currentThread().getId());
        threadIds = this.convertToLongArray(ids);
        return this.getThreadInfos(threadIds);
    }

    private ThreadInfo[] getRequestThreadInfos(Set<Long> requestThreadIds) {
        long[] threadIds = this.convertToLongArray(requestThreadIds);
        return this.getThreadInfos(threadIds);
    }

    private long[] convertToLongArray(Set<Long> ids) {
        long[] arr = new long[ids.size()];
        int i = 0;
        for (Long id : ids) {
            arr[i++] = id;
        }
        return arr;
    }

    private ThreadInfo[] getThreadInfos(long[] threadIds) {
        try {
            ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            if (threadIds.length > 0) {
                return threadMXBean.getThreadInfo(threadIds, 300);
            }
        }
        catch (SecurityException e) {
            Agent.LOG.finer(MessageFormat.format("An error occurred getting thread info: {0}", e));
        }
        return EMPTY_THREAD_INFO_ARRAY;
    }

    private long[] getAllThreadIds() {
        try {
            ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            return threadMXBean.getAllThreadIds();
        }
        catch (SecurityException e) {
            Agent.LOG.finer(MessageFormat.format("An error occurred getting all thread ids: {0}", e));
            return null;
        }
    }
}

