/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile.method;

import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.instrumentation.InstrumentedMethod;
import com.newrelic.agent.instrumentation.tracing.InstrumentationType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MethodInfo {
    public abstract List<Map<String, Object>> getJsonMethodMaps();

    protected static void addOneMethodInstrumentedInfo(Map<String, Object> toAdd, InstrumentedMethod instrumentedMethod) {
        if (instrumentedMethod != null) {
            HashMap<String, Object> inst = Maps.newHashMap();
            inst.put("dispatcher", instrumentedMethod.dispatcher());
            MethodInfo.addInstrumentationInfo(inst, instrumentedMethod);
            toAdd.put("traced_instrumentation", inst);
        }
    }

    private static void addInstrumentationInfo(Map<String, Object> inst, InstrumentedMethod instrumentedMethod) {
        InstrumentationType[] inputTypes = instrumentedMethod.instrumentationTypes();
        String[] inputNames = instrumentedMethod.instrumentationNames();
        if (inputTypes != null && inputNames != null && inputTypes.length > 0 && inputTypes.length == inputNames.length) {
            HashMap instrumentedTypes = Maps.newHashMap();
            for (int i = 0; i < inputTypes.length; ++i) {
                if (!MethodInfo.isTimedInstrumentation(inputTypes[i])) continue;
                ArrayList<String> names = (ArrayList<String>)instrumentedTypes.get(inputTypes[i].toString());
                if (names == null) {
                    names = Lists.newArrayList();
                    names.add(inputNames[i]);
                    instrumentedTypes.put(inputTypes[i].toString(), names);
                    continue;
                }
                names.add(inputNames[i]);
            }
            if (instrumentedTypes.size() > 0) {
                inst.put("types", instrumentedTypes);
            }
        }
    }

    private static boolean isTimedInstrumentation(InstrumentationType type) {
        return type != InstrumentationType.WeaveInstrumentation;
    }

    protected static void addOneMethodArgs(Map<String, Object> toAdd, List<String> arguments) {
        toAdd.put("args", arguments);
    }
}

