/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.Agent;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.TransactionListener;
import com.newrelic.agent.attributes.AttributesUtils;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentConfigListener;
import com.newrelic.agent.deps.com.google.common.cache.CacheBuilder;
import com.newrelic.agent.deps.com.google.common.cache.CacheLoader;
import com.newrelic.agent.deps.com.google.common.cache.LoadingCache;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.Service;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.analytics.TransactionEvent;
import com.newrelic.agent.service.analytics.TransactionEventsConfigUtils;
import com.newrelic.agent.stats.AbstractStats;
import com.newrelic.agent.stats.CountStats;
import com.newrelic.agent.stats.StatsBase;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.transaction.PriorityTransactionName;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionEventsService
extends AbstractService
implements Service,
HarvestListener,
TransactionListener,
AgentConfigListener {
    private final boolean enabled;
    private final int maxSamplesStored;
    final ConcurrentHashMap<String, EventData> eventData = new ConcurrentHashMap();
    private final ConcurrentMap<String, Boolean> isEnabledForApp = new ConcurrentHashMap<String, Boolean>();
    private final Random random = new Random();
    private final LoadingCache<String, String> transactionNameCache;

    public TransactionEventsService() {
        super(TransactionEventsService.class.getSimpleName());
        AgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        this.maxSamplesStored = TransactionEventsConfigUtils.getMaxSamplesStores(config);
        this.enabled = TransactionEventsConfigUtils.isTransactionEventsEnabled(config, this.maxSamplesStored);
        this.isEnabledForApp.put(config.getApplicationName(), this.enabled);
        this.transactionNameCache = CacheBuilder.newBuilder().maximumSize(this.maxSamplesStored).expireAfterAccess(5L, TimeUnit.MINUTES).build(new CacheLoader<String, String>(){

            @Override
            public String load(String key) throws Exception {
                return key;
            }
        });
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.enabled) {
            ServiceFactory.getHarvestService().addHarvestListener(this);
            ServiceFactory.getTransactionService().addTransactionListener(this);
            ServiceFactory.getConfigService().addIAgentConfigListener(this);
        }
    }

    @Override
    protected void doStop() throws Exception {
        ServiceFactory.getHarvestService().removeHarvestListener(this);
        ServiceFactory.getTransactionService().removeTransactionListener(this);
        ServiceFactory.getConfigService().removeIAgentConfigListener(this);
        this.eventData.clear();
    }

    @Override
    public void beforeHarvest(String appName, StatsEngine statsEngine) {
        EventData dataArray = this.eventData.put(appName, new EventData());
        if (dataArray == null || dataArray.insertCount.intValue() == 0) {
            return;
        }
        try {
            ServiceFactory.getRPMService(appName).sendAnalyticsEvents(Collections.unmodifiableList(Arrays.asList(dataArray.events).subList(0, Math.min(dataArray.insertCount.intValue(), dataArray.events.length))));
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINE, MessageFormat.format("Unable to send {0} events. Will attempt next harvest.", dataArray.events.length));
            EventData currentEventData = this.eventData.get(appName);
            for (int i = 0; i < Math.min(dataArray.events.length, currentEventData.insertCount.intValue()); ++i) {
                Integer insertIndex;
                TransactionEvent oldEvents = dataArray.events[i];
                if (oldEvents == null || (insertIndex = this.nextInsertIndex(currentEventData)) == null) continue;
                currentEventData.events[insertIndex.intValue()] = oldEvents;
            }
        }
    }

    @Override
    public void afterHarvest(String appName) {
    }

    private boolean getIsEnabledForApp(AgentConfig config, String currentAppName) {
        Boolean appEnabled = (Boolean)this.isEnabledForApp.get(currentAppName);
        if (appEnabled == null) {
            appEnabled = TransactionEventsConfigUtils.isTransactionEventsEnabled(config, TransactionEventsConfigUtils.getMaxSamplesStores(config));
            this.isEnabledForApp.put(currentAppName, appEnabled);
        }
        return appEnabled;
    }

    @Override
    public void dispatcherTransactionFinished(TransactionData transactionData, TransactionStats transactionStats) {
        PriorityTransactionName transactionName;
        String otherCategory;
        if (!this.getIsEnabledForApp(transactionData.getAgentConfig(), transactionData.getApplicationName())) {
            this.eventData.remove(transactionData.getApplicationName());
            return;
        }
        this.eventData.putIfAbsent(transactionData.getApplicationName(), new EventData());
        EventData currentEventData = this.eventData.get(transactionData.getApplicationName());
        Integer insertIndex = this.nextInsertIndex(currentEventData);
        if (insertIndex == null) {
            return;
        }
        long startTime = transactionData.getWallClockStartTimeMs();
        String metricName = transactionData.getBlameOrRootMetricName();
        try {
            metricName = this.transactionNameCache.get(metricName);
        }
        catch (ExecutionException e) {
            Agent.LOG.finest("Error fetching cached transaction name: " + e.toString());
        }
        long durationInNanos = transactionData.getDuration();
        Integer port = ServiceFactory.getEnvironmentService().getEnvironment().getAgentIdentity().getServerPort();
        String subType = "Web";
        if (!transactionData.isWebTransaction() && (otherCategory = (transactionName = transactionData.getPriorityTransactionName()).getCategory()) != null) {
            subType = otherCategory;
        }
        TransactionEvent event = new TransactionEvent(transactionData.getApplicationName(), subType, startTime, metricName, (float)durationInNanos / 1.0E9f, transactionData.getGuid(), transactionData.getReferrerGuid(), port, transactionData.getTripId(), transactionData.getReferringPathHash(), transactionData.getAlternatePathHashes(), transactionData.getApdexPerfZone());
        if (transactionData.getTripId() != null) {
            event.pathHash = transactionData.generatePathHash();
        }
        event.queueDuration = this.retrieveMetricIfExists(transactionStats, "WebFrontend/QueueTime").getTotal();
        event.externalDuration = this.retrieveMetricIfExists(transactionStats, "External/all").getTotal();
        event.externalCallCount = this.retrieveMetricIfExists(transactionStats, "External/all").getCallCount();
        event.databaseDuration = this.retrieveMetricIfExists(transactionStats, "Database/all").getTotal();
        event.databaseCallCount = this.retrieveMetricIfExists(transactionStats, "Database/all").getCallCount();
        List<CountStats> datastoreAll = this.retrieveMatchingMetrics(transactionStats, "Datastore/[^/]+/all");
        for (CountStats stats : datastoreAll) {
            if (event.databaseDuration == Float.NEGATIVE_INFINITY) {
                event.databaseDuration = stats.getTotal();
                event.databaseCallCount = stats.getCallCount();
                continue;
            }
            event.databaseDuration += stats.getTotal();
            event.databaseCallCount += (float)stats.getCallCount();
        }
        event.gcCumulative = this.retrieveMetricIfExists(transactionStats, "GC/cumulative").getTotal();
        if (ServiceFactory.getAttributesService().isAttributesEnabledForEvents(transactionData.getApplicationName())) {
            event.userAttributes = transactionData.getUserAttributes();
            event.agentAttributes = transactionData.getAgentAttributes();
            event.agentAttributes.putAll(AttributesUtils.appendAttributePrefixes(transactionData.getPrefixedAttributes()));
        }
        currentEventData.events[insertIndex.intValue()] = event;
    }

    private List<CountStats> retrieveMatchingMetrics(TransactionStats transactionStats, String metricNameRegex) {
        LinkedList<CountStats> matches = new LinkedList<CountStats>();
        for (String key : transactionStats.getUnscopedStats().getStatsMap().keySet()) {
            if (!key.matches(metricNameRegex)) continue;
            matches.add(transactionStats.getUnscopedStats().getResponseTimeStats(key));
        }
        return matches;
    }

    private CountStats retrieveMetricIfExists(TransactionStats transactionStats, String metricName) {
        if (!transactionStats.getUnscopedStats().getStatsMap().containsKey(metricName)) {
            return NoCallCountStats.NO_STATS;
        }
        return transactionStats.getUnscopedStats().getResponseTimeStats(metricName);
    }

    private Integer nextInsertIndex(EventData analyticsDataArray) {
        int insertIndex;
        int currentCount = analyticsDataArray.insertCount.getAndIncrement();
        if (currentCount < this.maxSamplesStored) {
            insertIndex = currentCount;
        } else {
            insertIndex = this.random.nextInt(currentCount);
            if (insertIndex >= this.maxSamplesStored) {
                return null;
            }
        }
        return insertIndex;
    }

    @Override
    public void configChanged(String appName, AgentConfig agentConfig) {
        this.isEnabledForApp.remove(appName);
    }

    static /* synthetic */ int access$000(TransactionEventsService x0) {
        return x0.maxSamplesStored;
    }

    private static class NoCallCountStats
    extends AbstractStats {
        static final NoCallCountStats NO_STATS = new NoCallCountStats();

        private NoCallCountStats() {
        }

        public float getTotal() {
            return Float.NEGATIVE_INFINITY;
        }

        public float getTotalExclusiveTime() {
            return Float.NEGATIVE_INFINITY;
        }

        public float getMinCallTime() {
            return Float.NEGATIVE_INFINITY;
        }

        public float getMaxCallTime() {
            return Float.NEGATIVE_INFINITY;
        }

        public double getSumOfSquares() {
            return Double.NEGATIVE_INFINITY;
        }

        public boolean hasData() {
            return false;
        }

        public void reset() {
        }

        public void merge(StatsBase stats) {
        }

        public Object clone() throws CloneNotSupportedException {
            return NO_STATS;
        }
    }

    class EventData {
        final AtomicInteger insertCount = new AtomicInteger();
        final TransactionEvent[] events = new TransactionEvent[TransactionEventsService.access$000(TransactionEventsService.this)];

        EventData() {
        }
    }
}

