/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.stats;

import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.stats.CountStats;
import com.newrelic.agent.stats.InvalidStatsException;
import com.newrelic.agent.stats.StatsBase;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractStats
implements CountStats {
    private static final List<Number> ZERO_ARRAY_LIST;
    protected int count;
    public static final StatsBase EMPTY_STATS;

    public AbstractStats() {
    }

    public AbstractStats(int count) {
        this.count = count;
    }

    public void incrementCallCount(int value) {
        this.count += value;
    }

    public void incrementCallCount() {
        ++this.count;
    }

    public int getCallCount() {
        return this.count;
    }

    public void setCallCount(int count) {
        this.count = count;
    }

    public final void writeJSONString(Writer writer) throws IOException, InvalidStatsException {
        List<Number> list = this.count < 0 ? ZERO_ARRAY_LIST : Arrays.asList(this.count, Float.valueOf(this.getTotal()), Float.valueOf(this.getTotalExclusiveTime()), Float.valueOf(this.getMinCallTime()), Float.valueOf(this.getMaxCallTime()), this.getSumOfSquares());
        JSONArray.writeJSONString(list, writer);
    }

    public abstract Object clone() throws CloneNotSupportedException;

    static {
        Integer zero = 0;
        ZERO_ARRAY_LIST = Arrays.asList(zero, zero, zero, zero, zero, zero);
        EMPTY_STATS = new StatsBase(){

            public boolean hasData() {
                return true;
            }

            public void merge(StatsBase stats) {
            }

            public void reset() {
            }

            public Object clone() throws CloneNotSupportedException {
                return super.clone();
            }

            public void writeJSONString(Writer writer) throws IOException {
                JSONArray.writeJSONString(ZERO_ARRAY_LIST, writer);
            }

            public boolean isValid() {
                return true;
            }
        };
    }
}

