/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.trace;

import com.newrelic.agent.Agent;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.trace.ITransactionSampler;
import com.newrelic.agent.trace.TransactionTrace;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionSampler
implements ITransactionSampler {
    private static final int MAX_TRANSACTIONS_PER_REPORTING_PERIOD = 10;
    private final AtomicReferenceArray<TransactionData> transactionTraces;
    private final AtomicLong totalTraceCount = new AtomicLong();
    private final AtomicInteger traceCount = new AtomicInteger();

    public TransactionSampler() {
        this.transactionTraces = new AtomicReferenceArray(10);
    }

    public boolean shouldGenerateBeaconGuid() {
        return this.traceCount.get() >= 10;
    }

    @Override
    public boolean noticeTransaction(TransactionData td) {
        if (td.getGuid() == null) {
            return false;
        }
        int index = (int)this.totalTraceCount.getAndIncrement() % 10;
        if (this.transactionTraces.compareAndSet(index, null, td)) {
            this.traceCount.getAndIncrement();
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Recording transaction trace for {0} guid: {1}", td.getApplicationName(), td.getGuid());
                Agent.LOG.finer(msg);
            }
            return true;
        }
        return false;
    }

    @Override
    public List<TransactionTrace> harvest(String appName) {
        ArrayList<TransactionTrace> traces = new ArrayList<TransactionTrace>(10);
        for (int i = 0; i < this.transactionTraces.length(); ++i) {
            TransactionData td = this.transactionTraces.get(i);
            if (td == null || td.getApplicationName() != appName) continue;
            this.traceCount.getAndDecrement();
            TransactionTrace trace = TransactionTrace.getTransactionTrace(td);
            traces.add(trace);
            this.transactionTraces.set(i, null);
        }
        return traces;
    }

    @Override
    public void stop() {
        for (int i = 0; i < this.transactionTraces.length(); ++i) {
            this.transactionTraces.set(i, null);
        }
    }

    @Override
    public long getMaxDurationInNanos() {
        return 0L;
    }
}

