/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.trace;

import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.IgnoreSilentlyException;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.TransactionListener;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.ConfigService;
import com.newrelic.agent.dispatchers.Dispatcher;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.trace.ITransactionGuidGenerator;
import com.newrelic.agent.trace.ITransactionSampler;
import com.newrelic.agent.trace.RandomTransactionSampler;
import com.newrelic.agent.trace.TransactionGuidFactory;
import com.newrelic.agent.trace.TransactionSampler;
import com.newrelic.agent.trace.TransactionTrace;
import com.newrelic.agent.trace.TransactionTraceBucket;
import com.newrelic.agent.trace.XRayTransactionSampler;
import com.newrelic.agent.xray.XRaySession;
import com.newrelic.agent.xray.XRaySessionListener;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionTraceService
extends AbstractService
implements HarvestListener,
TransactionListener,
ITransactionGuidGenerator,
XRaySessionListener {
    private static final int INITIAL_TRACE_LIMIT = 5;
    private final ThreadMXBean threadMXBean;
    private final ConcurrentMap<String, ITransactionSampler> transactionTraceBuckets;
    private final boolean autoAppNameEnabled;
    private final boolean threadCpuTimeEnabled;
    private final ConfigService configService;
    private final ITransactionSampler requestTraceBucket;
    private final ITransactionSampler backgroundTraceBucket;
    private final TransactionSampler guidTransactionSampler;
    private final List<ITransactionSampler> transactionSamplers = new CopyOnWriteArrayList<ITransactionSampler>();
    private final ConcurrentMap<Long, XRayTransactionSampler> xraySamplers;
    private final List<XRayTransactionSampler> xraySamplersPendingRemoval = new CopyOnWriteArrayList<XRayTransactionSampler>();

    public TransactionTraceService() {
        super(TransactionTraceService.class.getSimpleName());
        this.requestTraceBucket = this.createBucket();
        this.backgroundTraceBucket = this.createBucket();
        this.threadMXBean = ManagementFactory.getThreadMXBean();
        this.transactionTraceBuckets = new ConcurrentHashMap<String, ITransactionSampler>();
        this.configService = ServiceFactory.getConfigService();
        AgentConfig config = this.configService.getDefaultAgentConfig();
        this.autoAppNameEnabled = config.isAutoAppNamingEnabled();
        this.threadCpuTimeEnabled = this.initThreadCPUEnabled(config);
        this.guidTransactionSampler = new TransactionSampler();
        this.xraySamplers = new ConcurrentHashMap<Long, XRayTransactionSampler>();
    }

    public ThreadMXBean getThreadMXBean() {
        return this.threadMXBean;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public void addTransactionTraceSampler(ITransactionSampler transactionSampler) {
        this.transactionSamplers.add(transactionSampler);
    }

    public void removeTransactionTraceSampler(ITransactionSampler transactionSampler) {
        this.transactionSamplers.remove(transactionSampler);
    }

    public boolean isThreadCpuTimeEnabled() {
        return this.threadCpuTimeEnabled;
    }

    @Override
    public String generateBeaconGuid() {
        if (this.guidTransactionSampler.shouldGenerateBeaconGuid()) {
            return this.generateTransactionGuid();
        }
        return null;
    }

    @Override
    public String generateTransactionGuid() {
        return TransactionGuidFactory.generateGuid();
    }

    private boolean initThreadCPUEnabled(AgentConfig config) {
        boolean result = true;
        Boolean prop = (Boolean)config.getProperty("thread_cpu_time_enabled");
        if (prop == null) {
            String vendor = System.getProperty("java.vendor");
            if ("IBM Corporation".equals(vendor)) {
                return false;
            }
            return false;
        }
        result = prop;
        if (!result) {
            return false;
        }
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        return threadMXBean.isThreadCpuTimeSupported() && threadMXBean.isThreadCpuTimeEnabled();
    }

    private ITransactionSampler getTransactionTraceBucket(TransactionData transactionData) {
        if (this.autoAppNameEnabled) {
            return this.getOrCreateTransactionTraceBucket(transactionData.getApplicationName());
        }
        return this.getTransactionBucket(transactionData.getDispatcher());
    }

    private ITransactionSampler getOrCreateTransactionTraceBucket(String appName) {
        ITransactionSampler oldBucket;
        ITransactionSampler bucket = this.getTransactionTraceBucket(appName);
        if (bucket == null && (oldBucket = this.transactionTraceBuckets.putIfAbsent(appName, bucket = this.createBucket())) != null) {
            return oldBucket;
        }
        return bucket;
    }

    private ITransactionSampler getTransactionTraceBucket(String bucketName) {
        if ("request" == bucketName) {
            return this.requestTraceBucket;
        }
        if ("background" == bucketName) {
            return this.backgroundTraceBucket;
        }
        return (ITransactionSampler)this.transactionTraceBuckets.get(bucketName);
    }

    private String getTransactionBucketName(Dispatcher dispatcher) {
        return dispatcher.isWebTransaction() ? "request" : "background";
    }

    private void noticeTransaction(TransactionData transactionData) {
        if (this.guidTransactionSampler.noticeTransaction(transactionData)) {
            return;
        }
        for (ITransactionSampler transactionSampler : this.transactionSamplers) {
            if (!transactionSampler.noticeTransaction(transactionData)) continue;
            return;
        }
        ITransactionSampler bucket = this.getTransactionTraceBucket(transactionData);
        if (bucket != null) {
            bucket.noticeTransaction(transactionData);
        }
    }

    private ITransactionSampler getTransactionBucket(Dispatcher dispatcher) {
        ITransactionSampler bucket = this.getTransactionTraceBucket(this.getTransactionBucketName(dispatcher));
        if (bucket == null) {
            bucket = this.requestTraceBucket;
        }
        return bucket;
    }

    @Override
    public void beforeHarvest(String appName, StatsEngine statsEngine) {
    }

    @Override
    public void afterHarvest(String appName) {
        ArrayList<TransactionTrace> traces = new ArrayList<TransactionTrace>();
        if (this.autoAppNameEnabled) {
            traces.addAll(this.getExpensiveTransaction(appName));
        } else {
            traces.addAll(this.getAllExpensiveTransactions(appName));
        }
        traces.addAll(this.guidTransactionSampler.harvest(appName));
        for (ITransactionSampler transactionSampler : this.transactionSamplers) {
            traces.addAll(transactionSampler.harvest(appName));
        }
        if (!traces.isEmpty()) {
            IRPMService rpmService = ServiceFactory.getRPMService(appName);
            this.sendTraces(rpmService, traces);
        }
        if (!this.xraySamplersPendingRemoval.isEmpty()) {
            for (XRayTransactionSampler samplerToRemove : this.xraySamplersPendingRemoval) {
                this.removeTransactionTraceSampler(samplerToRemove);
            }
            this.xraySamplersPendingRemoval.clear();
        }
    }

    private List<TransactionTrace> getAllExpensiveTransactions(String appName) {
        ArrayList<TransactionTrace> traces = new ArrayList<TransactionTrace>();
        ArrayList<ITransactionSampler> allBuckets = new ArrayList<ITransactionSampler>(Arrays.asList(this.requestTraceBucket, this.backgroundTraceBucket));
        allBuckets.addAll(this.transactionTraceBuckets.values());
        for (ITransactionSampler bucket : allBuckets) {
            List<TransactionTrace> expensiveTransactions = bucket.harvest(appName);
            if (expensiveTransactions == null) continue;
            traces.addAll(expensiveTransactions);
        }
        return traces;
    }

    public List<TransactionTrace> getExpensiveTransaction(String appName) {
        ITransactionSampler bucket = this.getTransactionTraceBucket(appName);
        if (bucket != null) {
            return bucket.harvest(appName);
        }
        return Collections.emptyList();
    }

    private void sendTraces(IRPMService rpmService, List<TransactionTrace> traces) {
        block5: {
            if (!rpmService.isConnected()) {
                return;
            }
            try {
                rpmService.sendTransactionTraceData(traces);
            }
            catch (IgnoreSilentlyException e) {
            }
            catch (Exception e) {
                if (!this.getLogger().isLoggable(Level.FINER)) break block5;
                String msg = MessageFormat.format("Error sending transaction trace data to {0} for {1}: {2}", rpmService.getHostString(), rpmService.getApplicationName(), e.getMessage());
                if (this.getLogger().isLoggable(Level.FINEST)) {
                    this.getLogger().log(Level.FINEST, msg, e);
                }
                this.getLogger().finer(msg);
            }
        }
    }

    @Override
    protected void doStart() {
        ServiceFactory.getTransactionService().addTransactionListener(this);
        ServiceFactory.getHarvestService().addHarvestListener(this);
        ServiceFactory.getXRaySessionService().addListener(this);
        RandomTransactionSampler.startSampler(5);
    }

    @Override
    protected void doStop() {
        for (ITransactionSampler bucket : this.transactionTraceBuckets.values()) {
            bucket.stop();
        }
        this.transactionTraceBuckets.clear();
    }

    private ITransactionSampler createBucket() {
        return new TransactionTraceBucket();
    }

    @Override
    public void dispatcherTransactionFinished(TransactionData transactionData, TransactionStats transactionStats) {
        if (!transactionData.getTransactionTracerConfig().isEnabled()) {
            return;
        }
        if (transactionData.getResponseStatus() >= 400) {
            return;
        }
        this.noticeTransaction(transactionData);
    }

    public boolean isInteresting(Dispatcher dispatcher, long responseTimeNs) {
        return this.autoAppNameEnabled || responseTimeNs > this.getTransactionBucket(dispatcher).getMaxDurationInNanos();
    }

    @Override
    public void xraySessionCreated(XRaySession session) {
        this.getLogger().finer("TT service notified of X-Ray Session creation: " + session);
        XRayTransactionSampler sampler = new XRayTransactionSampler(session);
        this.xraySamplers.put(session.getxRayId(), sampler);
        this.transactionSamplers.add(0, sampler);
    }

    @Override
    public void xraySessionRemoved(XRaySession session) {
        XRayTransactionSampler samplerToRemove;
        this.getLogger().finer("TT service notified of X-Ray Session removal: " + session);
        if (null != session && (samplerToRemove = (XRayTransactionSampler)this.xraySamplers.remove(session.getxRayId())) != null) {
            this.xraySamplersPendingRemoval.add(samplerToRemove);
        }
    }
}

