/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.bridge.TracedMethod;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.tracers.AbstractExternalComponentTracer;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.CrossProcessNameFormat;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.api.agent.HeaderType;
import com.newrelic.api.agent.InboundHeaders;
import java.util.concurrent.TimeUnit;

public abstract class AbstractCrossProcessTracer
extends AbstractExternalComponentTracer
implements InboundHeaders {
    private CrossProcessNameFormat crossProcessFormat;
    private final String uri;
    private Object response;

    public AbstractCrossProcessTracer(Transaction transaction, ClassMethodSignature sig, Object object, String host, String library, String uri, String methodName) {
        super(transaction, sig, object, host, library, uri, methodName);
        this.uri = uri;
    }

    protected void doFinish(int opcode, Object returnValue) {
        this.response = returnValue;
        this.getTransaction().getCrossProcessState().processInboundResponseHeaders((InboundHeaders)this, (TracedMethod)this, this.getHost(), this.uri, false);
        super.doFinish(opcode, returnValue);
    }

    public void doFinish(Throwable throwable) {
        this.getTransaction().getCrossProcessState().processInboundResponseHeaders((InboundHeaders)this, (TracedMethod)this, this.getHost(), this.uri, false);
        super.doFinish(throwable);
    }

    public HeaderType getHeaderType() {
        return HeaderType.HTTP;
    }

    public String getHeader(String name) {
        return this.getHeaderValue(this.response, name);
    }

    protected abstract String getHeaderValue(Object var1, String var2);

    public void setMetricNameFormat(MetricNameFormat nameFormat) {
        super.setMetricNameFormat(nameFormat);
        if (nameFormat instanceof CrossProcessNameFormat) {
            this.crossProcessFormat = (CrossProcessNameFormat)nameFormat;
        }
    }

    protected void doRecordMetrics(TransactionStats transactionStats) {
        super.doRecordMetrics(transactionStats);
        if (this.crossProcessFormat != null) {
            String hostCrossProcessIdRollupMetricName = this.crossProcessFormat.getHostCrossProcessIdRollupMetricName();
            transactionStats.getUnscopedStats().getResponseTimeStats(hostCrossProcessIdRollupMetricName).recordResponseTime(this.getExclusiveDuration(), TimeUnit.NANOSECONDS);
        }
    }

    public String getUri() {
        return this.uri;
    }
}

