/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers.jasper;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.tracers.jasper.AbstractRUMState;
import com.newrelic.agent.tracers.jasper.GenerateVisitor;
import com.newrelic.agent.tracers.jasper.RUMState;
import com.newrelic.agent.tracers.jasper.TemplateText;
import java.util.regex.Matcher;

public class HeadState
extends AbstractRUMState {
    public RUMState process(Transaction tx, GenerateVisitor generator, TemplateText node, String text) throws Exception {
        Matcher matcher;
        Matcher scriptMatcher = SCRIPT_PATTERN.matcher(text);
        Integer scriptIndex = null;
        if (scriptMatcher.find()) {
            scriptIndex = scriptMatcher.end();
        }
        if ((matcher = HEAD_PATTERN.matcher(text)).find()) {
            if (this.isScriptFirst(scriptIndex, matcher.end())) {
                return PRE_HEAD_SCRIPT_STATE.process(tx, generator, node, text);
            }
            String s = text.substring(0, matcher.end());
            this.writeText(tx, generator, node, s);
            s = text.substring(matcher.end());
            return PRE_META_STATE.process(tx, generator, node, s);
        }
        matcher = HEAD_END_PATTERN.matcher(text);
        if (matcher.find()) {
            if (this.isScriptFirst(scriptIndex, matcher.end())) {
                String s = text.substring(0, scriptMatcher.start());
                this.writeText(tx, generator, node, s);
                this.writeHeader(generator);
                s = text.substring(scriptMatcher.start());
                return SCRIPT_STATE.process(tx, generator, node, s);
            }
            String s = text.substring(0, matcher.start());
            this.writeText(tx, generator, node, s);
            this.writeHeader(generator);
            s = text.substring(matcher.start());
            return BODY_STATE.process(tx, generator, node, s);
        }
        matcher = BODY_END_PATTERN.matcher(text);
        if (matcher.find()) {
            if (this.isScriptFirst(scriptIndex, matcher.end())) {
                return SCRIPT_STATE.process(tx, generator, node, text);
            }
            return BODY_STATE.process(tx, generator, node, text);
        }
        matcher = BODY_START_PATTERN.matcher(text);
        if (scriptIndex != null) {
            if (matcher.find()) {
                if (this.isScriptFirst(scriptIndex, matcher.end())) {
                    return PRE_HEAD_SCRIPT_STATE.process(tx, generator, node, text);
                }
                return SCRIPT_STATE.process(tx, generator, node, text);
            }
            return PRE_HEAD_SCRIPT_STATE.process(tx, generator, node, text);
        }
        this.writeText(tx, generator, node, text);
        return this;
    }

    private boolean isScriptFirst(Integer scriptIndex, Integer headIndex) {
        if (scriptIndex == null) {
            return false;
        }
        if (headIndex == null) {
            return true;
        }
        return headIndex > scriptIndex;
    }
}

