/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers.servlet;

import com.newrelic.agent.Agent;
import com.newrelic.agent.metric.MetricName;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.tracers.servlet.ExternalTimeTracker;
import com.newrelic.api.agent.Request;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ServerTimeTracker {
    protected static final String MISSING_SERVER_NAME_PREFIX = "unknown";
    public static final String REQUEST_X_START_HEADER = "X-Request-Start";
    private static final Pattern REQUEST_X_START_HEADER_PATTERN = Pattern.compile("([^\\s\\/,=\\(\\)]+)? ?t=(-?[0-9.]+)|(-?[0-9.]+)");
    private final long totalServerTime;
    private final Map<String, Long> serverTimes;

    private ServerTimeTracker(Request httpRequest, long txStartTimeInNanos, long queueTime) {
        String requestXStartHeader = ExternalTimeTracker.getRequestHeader(httpRequest, REQUEST_X_START_HEADER);
        if (requestXStartHeader == null) {
            this.serverTimes = Collections.emptyMap();
            this.totalServerTime = 0L;
        } else {
            this.serverTimes = new HashMap<String, Long>();
            this.totalServerTime = this.initRequestTime(requestXStartHeader, txStartTimeInNanos, queueTime);
        }
    }

    private long initRequestTime(String requestXStartHeader, long txStartTimeInNanos, long queueTime) {
        long totalServerTime = 0L;
        int index = 0;
        long lastServerStartTimeInNanos = 0L;
        String lastServerName = null;
        Matcher matcher = REQUEST_X_START_HEADER_PATTERN.matcher(requestXStartHeader);
        while (matcher.find()) {
            ++index;
            String serverName = matcher.group(1);
            if (serverName == null || serverName.length() == 0) {
                serverName = MISSING_SERVER_NAME_PREFIX + String.valueOf(index);
            }
            long serverStartTimeInNanos = 0L;
            String serverStartTime = matcher.group(2) != null ? matcher.group(2) : matcher.group(3);
            try {
                serverStartTimeInNanos = ExternalTimeTracker.parseTimestampToNano(serverStartTime);
                if (lastServerName != null) {
                    long serverTimeInNanos = Math.max(0L, serverStartTimeInNanos - lastServerStartTimeInNanos);
                    if (Agent.LOG.isLoggable(Level.FINEST)) {
                        String msg = MessageFormat.format("{0} start time (nanoseconds): {1}, {2} start time (in nanoseconds): {3}, {4} time (in nanoseconds): {5}", serverName, serverStartTimeInNanos, lastServerName, lastServerStartTimeInNanos, lastServerName, serverTimeInNanos);
                        Agent.LOG.finest(msg);
                    }
                    if (serverTimeInNanos > 0L) {
                        this.serverTimes.put(lastServerName, serverTimeInNanos);
                        totalServerTime += serverTimeInNanos;
                    }
                }
                lastServerStartTimeInNanos = serverStartTimeInNanos;
                lastServerName = serverName;
            }
            catch (NumberFormatException e) {
                String msg = MessageFormat.format("Error parsing server time {0} in {1}: {2}", serverStartTime, REQUEST_X_START_HEADER, e);
                Agent.LOG.log(Level.FINER, msg);
            }
        }
        if (lastServerName != null) {
            long serverTimeInNanos = Math.max(0L, txStartTimeInNanos - lastServerStartTimeInNanos - queueTime);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                String msg = MessageFormat.format("Transaction start time (nanoseconds): {0}, {1} start time (in nanoseconds): {2}, queue time (in nanoseconds): {3}, {4} time (in nanoseconds): {5}", txStartTimeInNanos, lastServerName, lastServerStartTimeInNanos, queueTime, lastServerName, serverTimeInNanos);
                Agent.LOG.finest(msg);
            }
            if (serverTimeInNanos > 0L) {
                this.serverTimes.put(lastServerName, serverTimeInNanos);
                totalServerTime += serverTimeInNanos;
            }
        }
        return totalServerTime;
    }

    public long getServerTime() {
        return this.totalServerTime;
    }

    public void recordMetrics(TransactionStats statsEngine) {
        if (this.totalServerTime > 0L) {
            this.recordAllServerTimeMetric(statsEngine, this.totalServerTime);
            for (Map.Entry<String, Long> entry : this.serverTimes.entrySet()) {
                this.recordServerTimeMetric(statsEngine, entry.getKey(), entry.getValue());
            }
        }
    }

    private void recordServerTimeMetric(TransactionStats statsEngine, String serverName, long serverTime) {
        String name = "WebFrontend/WebServer/" + serverName;
        statsEngine.getUnscopedStats().getResponseTimeStats(name).recordResponseTimeInNanos(serverTime);
        if (Agent.LOG.isLoggable(Level.FINEST)) {
            String msg = MessageFormat.format("Recorded metric: {0}, value: {1}", name, String.valueOf(serverTime));
            Agent.LOG.finest(msg);
        }
    }

    private void recordAllServerTimeMetric(TransactionStats statsEngine, long totalServerTime) {
        MetricName name = MetricName.QUEUE_TIME;
        statsEngine.getUnscopedStats().getResponseTimeStats(name.getName()).recordResponseTimeInNanos(totalServerTime);
    }

    public static ServerTimeTracker create(Request httpRequest, long txStartTimeInNanos, long queueTime) {
        return new ServerTimeTracker(httpRequest, txStartTimeInNanos, queueTime);
    }
}

