/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util;

import com.newrelic.agent.util.Streams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleverClassLoader
extends SecureClassLoader {
    public CleverClassLoader(ClassLoader parent) {
        super(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClassSpecial(String name) throws ClassNotFoundException, IOException {
        Class clazz;
        String fileName = name.replace('.', '/');
        fileName = fileName + ".class";
        InputStream inStream = ClassLoader.getSystemClassLoader().getResourceAsStream(fileName);
        if (inStream == null) {
            throw new ClassNotFoundException("Unable to find class " + name);
        }
        try {
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            Streams.copy(inStream, oStream);
            clazz = this.loadClass(name, oStream.toByteArray());
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            inStream.close();
            throw throwable;
        }
        inStream.close();
        return clazz;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (name.startsWith("com.newrelic")) {
            try {
                return ClassLoader.getSystemClassLoader().loadClass(name);
            }
            catch (NoClassDefFoundError e) {
                try {
                    return this.loadClassSpecial(name);
                }
                catch (IOException e1) {
                    throw e;
                }
            }
        }
        return super.loadClass(name);
    }

    protected Class loadClass(String name, byte[] bytes) {
        return this.defineClass(name, bytes, 0, bytes.length);
    }
}

