/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.util.asm.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarUtils {
    public static File createJarFile(String prefix, Map<String, byte[]> classes) throws IOException {
        return JarUtils.createJarFile(prefix, classes, null);
    }

    public static File createJarFile(String prefix, Map<String, byte[]> classes, Manifest manifest) throws IOException {
        File file = File.createTempFile(prefix, ".jar");
        file.deleteOnExit();
        if (manifest == null) {
            manifest = new Manifest();
        }
        JarOutputStream outStream = new JarOutputStream((OutputStream)new FileOutputStream(file), manifest);
        JarUtils.writeFilesToJarStream(classes, file, outStream);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFilesToJarStream(Map<String, byte[]> classes, File file, JarOutputStream outStream) throws IOException {
        HashMap<String, byte[]> resources = Maps.newHashMap();
        for (Map.Entry<String, byte[]> entry : classes.entrySet()) {
            resources.put(Utils.getClassResourceName(entry.getKey()), entry.getValue());
        }
        try {
            JarUtils.addJarEntries(outStream, resources);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            outStream.close();
            throw throwable;
        }
        outStream.close();
        Agent.LOG.finer("Created " + file.getAbsolutePath());
    }

    public static void addJarEntries(JarOutputStream jarStream, Map<String, byte[]> files) throws IOException {
        for (Map.Entry<String, byte[]> entry : files.entrySet()) {
            JarEntry jarEntry = new JarEntry(entry.getKey());
            jarStream.putNextEntry(jarEntry);
            jarStream.write(entry.getValue());
            jarStream.closeEntry();
        }
    }
}

