/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.websphere;

import com.newrelic.agent.Agent;
import com.newrelic.agent.bridge.WebsphereApi;
import com.newrelic.agent.jmx.values.WebSphere7JmxValues;
import com.newrelic.agent.jmx.values.WebSphereJmxValues;
import com.newrelic.agent.service.ServiceFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public class WebSphereApiImpl
implements WebsphereApi {
    private final AtomicBoolean addedJmx = new AtomicBoolean(false);

    public void servletContextInitialized(Object servletContext) {
    }

    public void serverStarted() {
        Agent.LOG.fine("Detected a starting WebSphere 8 server instance");
        if (this.addedJmx.compareAndSet(false, true)) {
            ServiceFactory.getJmxService().addJmxFrameworkValues(new WebSphereJmxValues());
            if (Agent.LOG.isFineEnabled()) {
                Agent.LOG.log(Level.FINE, "Added JMX for WebSphere 8");
            }
        }
    }

    public void serverStarted7() {
        Agent.LOG.fine("Detected a starting WebSphere 7 server instance");
        if (this.addedJmx.compareAndSet(false, true)) {
            ServiceFactory.getJmxService().addJmxFrameworkValues(new WebSphere7JmxValues());
            if (Agent.LOG.isFineEnabled()) {
                Agent.LOG.log(Level.FINE, "Added JMX for WebSphere 7");
            }
        }
    }
}

