/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.xray;

import com.newrelic.agent.Agent;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.xray.IXRaySessionService;
import com.newrelic.agent.xray.StartXRayCommand;
import com.newrelic.agent.xray.XRaySession;
import com.newrelic.agent.xray.XRaySessionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XRaySessionService
extends AbstractService
implements HarvestListener,
IXRaySessionService {
    private final Map<Long, XRaySession> sessions = new HashMap<Long, XRaySession>();
    private final boolean enabled;
    private final List<XRaySessionListener> listeners = new CopyOnWriteArrayList<XRaySessionListener>();
    public static final int MAX_SESSION_COUNT = 50;
    public static final long MAX_SESSION_DURATION_SECONDS = 86400L;
    public static final long MAX_TRACE_COUNT = 100L;

    public XRaySessionService() {
        super(XRaySessionService.class.getSimpleName());
        this.enabled = ServiceFactory.getConfigService().getDefaultAgentConfig().isXraySessionEnabled();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    protected void doStart() throws Exception {
        this.addCommands();
        ServiceFactory.getHarvestService().addHarvestListener(this);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceFactory.getHarvestService().removeHarvestListener(this);
    }

    private void addCommands() {
        ServiceFactory.getCommandParser().addCommands(new StartXRayCommand(this));
    }

    private void addSession(XRaySession newSession) {
        if (this.listeners.size() < 50) {
            Agent.LOG.info("Adding X-Ray session: " + newSession.toString());
            this.sessions.put(newSession.getxRayId(), newSession);
            for (XRaySessionListener listener : this.listeners) {
                listener.xraySessionCreated(newSession);
            }
        } else {
            Agent.LOG.error("Unable to add X-Ray Session because this would exceed the maximum number of concurrent X-Ray Sessions allowed.  Max allowed is 50");
        }
    }

    private void removeSession(Long sessionId) {
        XRaySession session = this.sessions.remove(sessionId);
        if (null == session) {
            Agent.LOG.info("Tried to remove X-Ray session " + sessionId + " but no such session exists.");
        } else {
            Agent.LOG.info("Removing X-Ray session: " + session.toString());
            for (XRaySessionListener listener : this.listeners) {
                listener.xraySessionRemoved(session);
            }
        }
    }

    @Override
    public void beforeHarvest(String appName, StatsEngine statsEngine) {
    }

    @Override
    public void afterHarvest(String appName) {
        HashSet<Long> expired = new HashSet<Long>();
        for (XRaySession session : this.sessions.values()) {
            if (!session.sessionHasExpired()) continue;
            expired.add(session.getxRayId());
            Agent.LOG.debug("Identified X-Ray session for expiration: " + session.toString());
        }
        for (Long key : expired) {
            XRaySession session = this.sessions.get(key);
            if (null == session) continue;
            Agent.LOG.info("Expiring X-Ray session: " + session.getxRaySessionName());
            this.removeSession(key);
        }
    }

    void setupSession(Map<?, ?> sessionMap, String applicationName) {
        Object requested_trace_count;
        Object duration_obj;
        Object xray_session_name;
        Object sample_period;
        Object key_transaction_name;
        Object run_profiler;
        Long xRayId = null;
        Boolean runProfiler = null;
        String keyTransactionName = null;
        Double samplePeriod = null;
        String xRaySessionName = null;
        Long duration = null;
        Long requestedTraceCount = null;
        Object x_ray_id = sessionMap.remove("x_ray_id");
        if (x_ray_id instanceof Long) {
            xRayId = (Long)x_ray_id;
        }
        if ((run_profiler = sessionMap.remove("run_profiler")) instanceof Boolean) {
            runProfiler = (Boolean)run_profiler;
        }
        if ((key_transaction_name = sessionMap.remove("key_transaction_name")) instanceof String) {
            keyTransactionName = (String)key_transaction_name;
        }
        if ((sample_period = sessionMap.remove("sample_period")) instanceof Double) {
            samplePeriod = (Double)sample_period;
        }
        if ((xray_session_name = sessionMap.remove("xray_session_name")) instanceof String) {
            xRaySessionName = (String)xray_session_name;
        }
        if ((duration_obj = sessionMap.remove("duration")) instanceof Long) {
            duration = (Long)duration_obj;
            if (duration < 0L) {
                duration = 0L;
                Agent.LOG.error("Tried to create an X-Ray Session with negative duration, setting duration to 0");
            } else if (duration > 86400L) {
                Agent.LOG.error("Tried to create an X-Ray session with a duration (" + duration + ") longer than " + 86400L + " seconds.  Setting the duration to " + 86400L + " seconds");
                duration = 86400L;
            }
        }
        if ((requested_trace_count = sessionMap.remove("requested_trace_count")) instanceof Long) {
            requestedTraceCount = (Long)requested_trace_count;
            if (requestedTraceCount > 100L) {
                Agent.LOG.error("Tried to create an X-Ray session with a requested trace count (" + requestedTraceCount + ") larger than " + 100L + ".  Setting the max trace count to " + 100L);
                requestedTraceCount = 100L;
            } else if (requestedTraceCount < 0L) {
                Agent.LOG.error("Tried to create an X-Ray Session with negative trace count, setting trace count to 0");
                requestedTraceCount = 0L;
            }
        }
        XRaySession newSession = new XRaySession(xRayId, runProfiler, keyTransactionName, samplePeriod, xRaySessionName, duration, requestedTraceCount, applicationName);
        this.addSession(newSession);
    }

    @Override
    public Map<?, ?> processSessionsList(List<Long> incomingList, IRPMService rpmService) {
        HashSet<Long> sessionIdsToAdd = new HashSet<Long>();
        HashSet<Long> sessionIdsToRemove = new HashSet<Long>();
        String applicationName = rpmService.getApplicationName();
        for (Long id : incomingList) {
            if (this.sessions.keySet().contains(id)) continue;
            sessionIdsToAdd.add(id);
        }
        for (long id : this.sessions.keySet()) {
            if (incomingList.contains(id)) continue;
            Agent.LOG.debug("Identified " + id + " for removal from the active list of X-Ray sessions");
            sessionIdsToRemove.add(id);
        }
        if (sessionIdsToRemove.size() > 0) {
            Agent.LOG.debug("Removing " + sessionIdsToRemove + " from the active list of X-Ray sessions");
            for (Long id : sessionIdsToRemove) {
                this.removeSession(id);
            }
        }
        if (sessionIdsToAdd.size() > 0) {
            Collection<?> newSessionDetails;
            Agent.LOG.debug("Fetching details for " + sessionIdsToAdd + " to add to the active list of X Ray Sessions");
            try {
                newSessionDetails = rpmService.getXRaySessionInfo(sessionIdsToAdd);
            }
            catch (Exception e) {
                Agent.LOG.error("Unable to fetch X-Ray session details from RPM" + e.getMessage());
                return Collections.EMPTY_MAP;
            }
            for (Object newSession : newSessionDetails) {
                if (newSession instanceof Map) {
                    Map newSessionMap = (Map)newSession;
                    this.setupSession(newSessionMap, applicationName);
                    continue;
                }
                Agent.LOG.error("Unable to read X-Ray session details: " + newSession);
            }
        }
        Agent.LOG.debug("Resulting collection of X-Ray sessions: " + this.sessions);
        return Collections.EMPTY_MAP;
    }

    @Override
    public void addListener(XRaySessionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(XRaySessionListener listener) {
        this.listeners.remove(listener);
    }
}

