/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.bootstrap;

import com.newrelic.bootstrap.BootstrapLoader;
import com.newrelic.bootstrap.WsLogManagerTransformer;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class BootstrapAgent {
    private static final String NEW_RELIC_JAR_FILE = "newrelic.jar";
    public static final String AGENT_CLASS_NAME = "com.newrelic.agent.Agent";
    public static final String NEW_RELIC_BOOTSTRAP_CLASSPATH = "newrelic.bootstrap_classpath";
    public static final ClassLoader AGENT_CLASSLOADER = BootstrapAgent.class.getClassLoader();
    private static final String WS_SERVER_JAR = "ws-server.jar";
    private static final String IBM_VENDOR = "IBM";
    private static final String DELAY_AGENT_START = "newrelic.config.delay_agent_start";

    private static JarFile getAgentJarFile(URL agentJarUrl) {
        if (agentJarUrl == null) {
            return null;
        }
        try {
            return new JarFile(URLDecoder.decode(agentJarUrl.getFile().replace("+", "%2B"), "UTF-8"));
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL getAgentJarUrl() {
        ClassLoader classLoader = BootstrapAgent.class.getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            URL[] urls;
            for (URL url : urls = ((URLClassLoader)classLoader).getURLs()) {
                if (!url.getFile().endsWith(NEW_RELIC_JAR_FILE)) continue;
                return url;
            }
            String agentClassName = BootstrapAgent.class.getName().replace('.', '/') + ".class";
            for (URL url : urls) {
                JarFile jarFile = null;
                try {
                    jarFile = new JarFile(url.getFile());
                    ZipEntry entry = jarFile.getEntry(agentClassName);
                    if (entry == null) continue;
                    URL uRL = url;
                    return uRL;
                }
                catch (IOException e) {
                }
                finally {
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            Collection<URL> urls = BootstrapLoader.getJarURLs();
            urls.add(BootstrapAgent.getAgentJarUrl());
            URLClassLoader classLoader = new URLClassLoader(urls.toArray(new URL[0]), null);
            Class<?> agentClass = classLoader.loadClass(AGENT_CLASS_NAME);
            Method main = agentClass.getDeclaredMethod("main", String[].class);
            main.invoke(null, new Object[]{args});
        }
        catch (Throwable t) {
            System.err.println(MessageFormat.format("Error invoking the New Relic command: {0}", t));
            t.printStackTrace();
        }
    }

    public static void premain(String agentArgs, Instrumentation inst) {
        String delay_agent_start;
        String javaClassPath;
        String javaVersion = System.getProperty("java.version", "");
        if (javaVersion.startsWith("1.5")) {
            String msg = MessageFormat.format("Java version is: {0}.  This version of the New Relic Agent does not support Java 1.5.  Please use a 2.21.x or earlier version.", javaVersion);
            System.err.println("----------");
            System.err.println(msg);
            System.err.println("----------");
            return;
        }
        String javaVendor = System.getProperty("java.vendor");
        if (javaVendor != null && javaVendor.startsWith(IBM_VENDOR) && (javaClassPath = System.getProperty("java.class.path")) != null && javaClassPath.contains(WS_SERVER_JAR) && ((delay_agent_start = System.getProperty(DELAY_AGENT_START)) == null || Boolean.getBoolean(DELAY_AGENT_START))) {
            System.out.println("Delaying New Relic Agent");
            inst.addTransformer(new WsLogManagerTransformer(agentArgs, inst));
            return;
        }
        BootstrapAgent.startAgent(agentArgs, inst);
    }

    static void startAgent(String agentArgs, Instrumentation inst) {
        if (BootstrapAgent.isBootstrapClasspathFlagSet()) {
            Class clazz = BootstrapLoader.class;
            clazz = BootstrapLoader.ApiClassTransformer.class;
            BootstrapAgent.appendJarToBootstrapClassLoader(inst);
        }
        try {
            BootstrapLoader.load(inst);
            Class<?> agentClass = ClassLoader.getSystemClassLoader().loadClass(AGENT_CLASS_NAME);
            Method premain = agentClass.getDeclaredMethod("premain", String.class, Instrumentation.class);
            premain.invoke(null, agentArgs, inst);
        }
        catch (Throwable t) {
            System.err.println(MessageFormat.format("Error bootstrapping New Relic agent: {0}", t));
            t.printStackTrace();
        }
    }

    public static boolean isBootstrapClasspathFlagSet() {
        return Boolean.getBoolean(NEW_RELIC_BOOTSTRAP_CLASSPATH);
    }

    private static void appendJarToBootstrapClassLoader(Instrumentation inst) {
        URL agentJarUrl = BootstrapAgent.getAgentJarUrl();
        JarFile agentJarFile = BootstrapAgent.getAgentJarFile(agentJarUrl);
        if (agentJarFile != null) {
            inst.appendToBootstrapClassLoaderSearch(agentJarFile);
        }
    }
}

