/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.bootstrap;

import com.newrelic.bootstrap.BootstrapAgent;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.text.MessageFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsLogManagerTransformer
implements ClassFileTransformer {
    private final String agentArgs;
    private final Instrumentation inst;
    private static final String WS_LOG_MANAGER_CLASS_NAME = "com/ibm/ws/kernel/boot/logging/WsLogManager";

    public WsLogManagerTransformer(String agentArgs, Instrumentation inst) {
        this.agentArgs = agentArgs;
        this.inst = inst;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (WS_LOG_MANAGER_CLASS_NAME.equals(className)) {
            this.inst.removeTransformer(this);
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        BootstrapAgent.startAgent(WsLogManagerTransformer.this.agentArgs, WsLogManagerTransformer.this.inst);
                    }
                    catch (Throwable t) {
                        System.err.println(MessageFormat.format("Error bootstrapping New Relic agent: {0}", t));
                        t.printStackTrace();
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
        }
        return null;
    }
}

