/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.webcontainer;

import java.io.Serializable;
import java.security.Principal;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import nextapp.echo.app.TaskQueueHandle;
import nextapp.echo.webcontainer.ClientConfiguration;
import nextapp.echo.webcontainer.ClientProperties;
import nextapp.echo.webcontainer.Connection;
import nextapp.echo.webcontainer.ContainerContext;
import nextapp.echo.webcontainer.Service;
import nextapp.echo.webcontainer.UserInstance;
import nextapp.echo.webcontainer.WebContainerServlet;

class ContainerContextImpl
implements ContainerContext,
Serializable {
    private static final long serialVersionUID = 20070101L;
    private UserInstance userInstance;

    ContainerContextImpl(UserInstance userInstance) {
        this.userInstance = userInstance;
    }

    public void addCookie(Cookie cookie) throws IllegalStateException {
        Connection conn = WebContainerServlet.getActiveConnection();
        if (conn == null) {
            throw new IllegalStateException("No connection available to set cookie.");
        }
        conn.getResponse().addCookie(cookie);
    }

    public ClientProperties getClientProperties() {
        return this.userInstance.getClientProperties();
    }

    public Cookie[] getCookies() {
        Connection conn = WebContainerServlet.getActiveConnection();
        if (conn == null) {
            return null;
        }
        return conn.getRequest().getCookies();
    }

    public Map getInitialRequestParameterMap() {
        return this.userInstance.getInitialRequestParameterMap();
    }

    public String getServiceUri(Service service) {
        return this.userInstance.getServiceUri(service);
    }

    public String getServletUri() {
        return this.userInstance.getServletUri();
    }

    public HttpSession getSession() {
        return this.userInstance.getSession();
    }

    public Principal getUserPrincipal() {
        Connection conn = WebContainerServlet.getActiveConnection();
        if (conn == null) {
            return null;
        }
        return conn.getRequest().getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        Connection conn = WebContainerServlet.getActiveConnection();
        if (conn == null) {
            return false;
        }
        return conn.getRequest().isUserInRole(role);
    }

    public void setClientConfiguration(ClientConfiguration clientConfiguration) {
        this.userInstance.setClientConfiguration(clientConfiguration);
    }

    public void setTaskQueueCallbackInterval(TaskQueueHandle taskQueue, int ms) {
        this.userInstance.setTaskQueueCallbackInterval(taskQueue, ms);
    }
}

