/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.webcontainer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import nextapp.echo.webcontainer.Connection;
import nextapp.echo.webcontainer.Service;
import nextapp.echo.webcontainer.UserInstance;

public class UserInstanceContainer
implements HttpSessionActivationListener,
HttpSessionBindingListener,
Serializable {
    private int nextUserInstanceId = 0;
    private int nextInitId = 0;
    private String characterEncoding = "UTF-8";
    private String servletUri;
    private Map clientWindowIdToUserInstance = new HashMap();
    private Map idToUserInstance = new HashMap();
    private Map initIdToInitialRequestParameterMap = new HashMap();
    private transient HttpSession session;
    private boolean windowSpecificUserInstances;

    public static void newInstance(Connection conn) {
        new UserInstanceContainer(conn);
    }

    private UserInstanceContainer(Connection conn) {
        conn.initUserInstanceContainer(this);
        this.windowSpecificUserInstances = conn.getServlet().getInstanceMode() == 1;
    }

    private void dispose() {
        Iterator it = this.idToUserInstance.values().iterator();
        while (it.hasNext()) {
            UserInstance userInstance = (UserInstance)it.next();
            userInstance.dispose();
        }
    }

    public String createInitId(Connection conn) {
        HashMap parameterMap = new HashMap(conn.getRequest().getParameterMap());
        String initId = new Integer(this.nextInitId++).toString();
        this.initIdToInitialRequestParameterMap.put(initId, parameterMap);
        return initId;
    }

    synchronized UserInstance loadUserInstance(String clientWindowId, String initId) {
        UserInstance userInstance;
        if (!this.windowSpecificUserInstances) {
            clientWindowId = null;
        }
        if ((userInstance = (UserInstance)this.clientWindowIdToUserInstance.get(clientWindowId)) == null) {
            String uiid = this.windowSpecificUserInstances ? new Integer(this.nextUserInstanceId++).toString() : null;
            Map initialRequestParameterMap = (Map)this.initIdToInitialRequestParameterMap.remove(initId);
            userInstance = new UserInstance(this, uiid, clientWindowId, initialRequestParameterMap);
            this.clientWindowIdToUserInstance.put(clientWindowId, userInstance);
            this.idToUserInstance.put(userInstance.getId(), userInstance);
        }
        return userInstance;
    }

    synchronized void unloadUserInstance(UserInstance userInstance) {
        userInstance.dispose();
        this.clientWindowIdToUserInstance.remove(userInstance.getClientWindowId());
        this.idToUserInstance.remove(userInstance.getId());
    }

    synchronized UserInstance getUserInstanceById(String id) {
        return (UserInstance)this.idToUserInstance.get(id);
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public String getRootHtmlElementId() {
        return "approot";
    }

    HttpSession getSession() {
        return this.session;
    }

    public String getServiceUri(Service service, String userInstanceId) {
        StringBuffer out = new StringBuffer(this.getServletUri());
        out.append("?");
        out.append("sid");
        out.append("=");
        out.append(service.getId());
        if (userInstanceId != null) {
            out.append("&");
            out.append("uiid");
            out.append("=");
            out.append(userInstanceId);
        }
        return out.toString();
    }

    public String getServiceUri(Service service, String userInstanceId, String[] parameterNames, String[] parameterValues) {
        StringBuffer out = new StringBuffer(this.getServletUri());
        out.append("?");
        out.append("sid");
        out.append("=");
        out.append(service.getId());
        if (userInstanceId != null) {
            out.append("&");
            out.append("uiid");
            out.append("=");
            out.append(userInstanceId);
        }
        for (int i = 0; i < parameterNames.length; ++i) {
            out.append("&");
            out.append(parameterNames[i]);
            if (parameterValues[i] == null) continue;
            out.append("=");
            out.append(parameterValues[i]);
        }
        return out.toString();
    }

    public String getServletUri() {
        return this.servletUri;
    }

    void setServletUri(String servletUri) {
        this.servletUri = servletUri;
    }

    public synchronized void sessionDidActivate(HttpSessionEvent e) {
        this.session = e.getSession();
        Iterator it = this.idToUserInstance.values().iterator();
        while (it.hasNext()) {
            UserInstance userInstance = (UserInstance)it.next();
            if (userInstance.getApplicationInstance() == null) continue;
            userInstance.getApplicationInstance().activate();
        }
    }

    public synchronized void sessionWillPassivate(HttpSessionEvent e) {
        Iterator it = this.idToUserInstance.values().iterator();
        while (it.hasNext()) {
            UserInstance userInstance = (UserInstance)it.next();
            if (userInstance.getApplicationInstance() == null) continue;
            userInstance.getApplicationInstance().passivate();
        }
        this.session = null;
    }

    public void valueBound(HttpSessionBindingEvent e) {
        this.session = e.getSession();
    }

    public void valueUnbound(HttpSessionBindingEvent e) {
        this.dispose();
        this.session = null;
    }
}

