/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.webcontainer.service;

import java.io.IOException;
import nextapp.echo.app.AwtImageReference;
import nextapp.echo.app.ImageReference;
import nextapp.echo.app.StreamImageReference;
import nextapp.echo.webcontainer.Connection;
import nextapp.echo.webcontainer.ContentType;
import nextapp.echo.webcontainer.Service;
import nextapp.echo.webcontainer.SynchronizationException;
import nextapp.echo.webcontainer.UserInstance;
import nextapp.echo.webcontainer.util.PngEncoder;

public class ImageService
implements Service {
    private static final String SERVICE_ID = "Echo.Image";
    public static final ImageService INSTANCE = new ImageService();
    private static final String PARAMETER_IMAGE_UID = "iid";
    private static final String[] URL_PARAMETERS = new String[]{"iid"};

    public String getId() {
        return SERVICE_ID;
    }

    public int getVersion() {
        return 0;
    }

    public String createUri(UserInstance userInstance, String imageId) {
        return userInstance.getServiceUri(this, URL_PARAMETERS, new String[]{imageId});
    }

    public void renderImage(Connection conn, ImageReference imageReference) throws IOException {
        if (imageReference instanceof StreamImageReference) {
            this.renderStreamImage(conn, imageReference);
        } else if (imageReference instanceof AwtImageReference) {
            this.renderAwtImage(conn, imageReference);
        } else {
            throw new SynchronizationException("Unsupported image type: " + imageReference.getClass().getName(), null);
        }
    }

    private void renderAwtImage(Connection conn, ImageReference imageReference) throws IOException {
        try {
            PngEncoder encoder = new PngEncoder(((AwtImageReference)imageReference).getImage(), true, null, 3);
            conn.setContentType(ContentType.IMAGE_PNG);
            encoder.encode(conn.getOutputStream());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void renderStreamImage(Connection conn, ImageReference imageReference) throws IOException {
        try {
            StreamImageReference streamImageReference = (StreamImageReference)imageReference;
            conn.setContentType(new ContentType(streamImageReference.getContentType(), true));
            streamImageReference.render(conn.getOutputStream());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ImageReference getImage(UserInstance userInstance, String imageId) {
        return (ImageReference)userInstance.getIdTable().getObject(imageId);
    }

    public void service(Connection conn) throws IOException {
        UserInstance userInstance = conn.getUserInstance();
        if (userInstance == null) {
            this.serviceBadRequest(conn, "No container available.");
            return;
        }
        String imageId = conn.getRequest().getParameter(PARAMETER_IMAGE_UID);
        if (imageId == null) {
            this.serviceBadRequest(conn, "Image UID not specified.");
            return;
        }
        ImageReference imageReference = this.getImage(userInstance, imageId);
        if (imageReference == null) {
            this.serviceBadRequest(conn, "Image UID is not valid.");
            return;
        }
        this.renderImage(conn, imageReference);
    }

    private void serviceBadRequest(Connection conn, String message) {
        conn.getResponse().setStatus(400);
        conn.setContentType(ContentType.TEXT_PLAIN);
        conn.getWriter().write(message);
    }
}

