/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.webcontainer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import nextapp.echo.app.serial.PropertyPeerFactory;
import nextapp.echo.app.serial.SerialException;
import nextapp.echo.app.serial.SerialPropertyPeer;
import nextapp.echo.app.util.Context;
import nextapp.echo.app.util.DomUtil;
import nextapp.echo.webcontainer.ClientMessage;
import nextapp.echo.webcontainer.ClientProperties;
import nextapp.echo.webcontainer.Connection;
import nextapp.echo.webcontainer.SynchronizationException;
import nextapp.echo.webcontainer.UserInstance;
import nextapp.echo.webcontainer.WebContainerServlet;
import org.w3c.dom.Element;

public class ClientPropertiesInputProcessor
implements ClientMessage.Processor {
    private static final Map TYPE_MAP;

    public void process(Context context, Element dirElement) throws IOException {
        ClientProperties clientProperties = new ClientProperties();
        Connection conn = WebContainerServlet.getActiveConnection();
        Enumeration localeEnum = conn.getRequest().getLocales();
        ArrayList localeList = new ArrayList();
        while (localeEnum.hasMoreElements()) {
            localeList.add(localeEnum.nextElement());
        }
        clientProperties.setProperty("locales", localeList.toArray(new Locale[localeList.size()]));
        clientProperties.setProperty("remoteHost", conn.getRequest().getRemoteHost());
        PropertyPeerFactory propertyPeerFactory = (PropertyPeerFactory)context.get(PropertyPeerFactory.class);
        Element[] pElements = DomUtil.getChildElementsByTagName((Element)dirElement, (String)"p");
        for (int i = 0; i < pElements.length; ++i) {
            try {
                String propertyName = pElements[i].getAttribute("n");
                Class propertyClass = (Class)TYPE_MAP.get(propertyName);
                if (propertyClass == null) {
                    throw new SynchronizationException("Illegal property in ClientProperties message: " + propertyName, null);
                }
                SerialPropertyPeer propertyPeer = propertyPeerFactory.getPeerForProperty(propertyClass);
                Object propertyValue = propertyPeer.toProperty(context, propertyClass, pElements[i]);
                clientProperties.setProperty(propertyName, propertyValue);
                continue;
            }
            catch (SerialException serialException) {
                // empty catch block
            }
        }
        UserInstance userInstance = (UserInstance)context.get(UserInstance.class);
        userInstance.setClientProperties(clientProperties);
    }

    static {
        HashMap<String, Class> m = new HashMap<String, Class>();
        m.put("screenWidth", Integer.class);
        m.put("screenHeight", Integer.class);
        m.put("screenColorDepth", Integer.class);
        m.put("utcOffset", Integer.class);
        m.put("navigatorAppCodeName", String.class);
        m.put("navigatorAppName", String.class);
        m.put("navigatorAppVersion", String.class);
        m.put("navigatorCookieEnabled", Boolean.class);
        m.put("navigatorJavaEnabled", Boolean.class);
        m.put("navigatorLanguage", String.class);
        m.put("navigatorPlatform", String.class);
        m.put("navigatorUserAgent", String.class);
        m.put("browserChrome", Boolean.class);
        m.put("browserOpera", Boolean.class);
        m.put("browserKonqueror", Boolean.class);
        m.put("browserSafari", Boolean.class);
        m.put("browserMozilla", Boolean.class);
        m.put("browserMozillaFirefox", Boolean.class);
        m.put("browserInternetExplorer", Boolean.class);
        m.put("browserVersionMajor", Integer.class);
        m.put("browserVersionMinor", Integer.class);
        m.put("engineGecko", Boolean.class);
        m.put("engineKHTML", Boolean.class);
        m.put("engineMSHTML", Boolean.class);
        m.put("enginePresto", Boolean.class);
        m.put("engineWebKit", Boolean.class);
        m.put("engineVersionMajor", Integer.class);
        m.put("engineVersionMinor", Integer.class);
        TYPE_MAP = Collections.unmodifiableMap(m);
    }
}

