/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.webcontainer;

import java.util.HashMap;
import java.util.Map;
import nextapp.echo.webcontainer.ContentType;

public class ResourceRegistry {
    private Map packageMap = new HashMap();

    public synchronized void addPackage(String packageId, String location) {
        PackageData packageData = (PackageData)this.packageMap.get(packageId);
        if (packageData != null) {
            if (packageData.location.equals(location)) {
                return;
            }
            throw new IllegalArgumentException("Cannot change location of resource package \"" + packageId + "\".");
        }
        this.packageMap.put(packageId, new PackageData(location));
    }

    public synchronized void add(String packageId, String resourceName, ContentType contentType) {
        PackageData packageData = (PackageData)this.packageMap.get(packageId);
        if (packageData == null) {
            throw new IllegalArgumentException("Resource package \"" + packageId + "\" has not been registered.");
        }
        if (packageData.resourceNameToContentType.get(resourceName) != null) {
            throw new IllegalArgumentException("Resource \"" + packageId + ":" + resourceName + "\" already registered.");
        }
        packageData.resourceNameToContentType.put(resourceName, contentType);
    }

    public ContentType getContentType(String packageId, String resourceName) {
        PackageData packageData = (PackageData)this.packageMap.get(packageId);
        if (packageData == null) {
            return null;
        }
        return (ContentType)packageData.resourceNameToContentType.get(resourceName);
    }

    public String getLocation(String packageId, String resourceName) {
        PackageData packageData = (PackageData)this.packageMap.get(packageId);
        if (packageData == null) {
            throw new IllegalArgumentException("Resource package \"" + packageId + "\" has not been registered.");
        }
        if (!packageData.resourceNameToContentType.containsKey(resourceName)) {
            throw new IllegalArgumentException("Resource \"" + packageId + ":" + resourceName + "\" has not been registered.");
        }
        return packageData.location + resourceName;
    }

    private class PackageData {
        String location;
        Map resourceNameToContentType = new HashMap();

        PackageData(String location) {
            this.location = location;
        }
    }
}

