/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.webcontainer;

import java.util.Map;

public class ServerConfiguration {
    public static boolean DEBUG;
    public static boolean DEBUG_PRINT_MESSAGES_TO_CONSOLE;
    public static boolean ALLOW_IE_COMPRESSION;
    public static boolean JAVASCRIPT_COMPRESSION_ENABLED;
    public static boolean IE_EDGE_MODE;
    public static String NOSCRIPT_MESSAGE;
    public static String NOSCRIPT_URL;

    private static void readConfiguration(Map initParameters) {
        DEBUG = ServerConfiguration.getConfigValue("echo.debug", initParameters, false);
        DEBUG_PRINT_MESSAGES_TO_CONSOLE = ServerConfiguration.getConfigValue("echo.syncdump", initParameters, false);
        ALLOW_IE_COMPRESSION = ServerConfiguration.getConfigValue("echo.allowiecompression", initParameters, false);
        JAVASCRIPT_COMPRESSION_ENABLED = ServerConfiguration.getConfigValue("echo.javascript.compression", initParameters, false);
        IE_EDGE_MODE = ServerConfiguration.getConfigValue("echo.ie-edge-mode", initParameters, true);
        NOSCRIPT_MESSAGE = ServerConfiguration.getConfigValue("echo.noscript.message", initParameters, "This site only works with JavaScript enabled. Please enable JavaScript and reload the page. Hints how to enable JavaScript can be found at: ");
        NOSCRIPT_URL = ServerConfiguration.getConfigValue("echo.noscript.url", initParameters, "http://www.enable-javascript.com/");
    }

    public static void adoptServletConfiguration(Map initParameters) {
        ServerConfiguration.readConfiguration(initParameters);
    }

    private static String getConfigValue(String name, Map initParameters, String defaultValue) {
        if (System.getProperties().containsKey(name)) {
            return System.getProperty(name);
        }
        if (initParameters != null && initParameters.containsKey(name)) {
            return (String)initParameters.get(name);
        }
        return defaultValue;
    }

    private static boolean getConfigValue(String name, Map initParameters, boolean defaultValue) {
        return Boolean.valueOf(ServerConfiguration.getConfigValue(name, initParameters, String.valueOf(defaultValue)));
    }

    static {
        ServerConfiguration.readConfiguration(null);
    }
}

