/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.webcontainer.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import nextapp.echo.app.util.DomUtil;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XmlRequestParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream cleanXmlInputStream(InputStream in, String characterEncoding) throws IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int bytesRead = 0;
        try {
            do {
                if ((bytesRead = in.read(buffer)) <= 0) continue;
                byteOut.write(buffer, 0, bytesRead);
            } while (bytesRead > 0);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        in.close();
        byte[] data = byteOut.toByteArray();
        data = new String(data, characterEncoding).trim().getBytes(characterEncoding);
        return new ByteArrayInputStream(data);
    }

    public static Document parse(HttpServletRequest request, String characterEncoding) throws IOException {
        InputStream in = null;
        try {
            String userAgent = request.getHeader("user-agent");
            in = userAgent != null && userAgent.indexOf("onqueror") != -1 ? XmlRequestParser.cleanXmlInputStream((InputStream)request.getInputStream(), characterEncoding) : request.getInputStream();
            Document document = DomUtil.getDocumentBuilder().parse(in);
            return document;
        }
        catch (SAXException ex) {
            throw new InvalidXmlException("Provided InputStream cannot be parsed.", ex);
        }
        catch (IOException ex) {
            throw new InvalidXmlException("Provided InputStream cannot be parsed.", ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static class InvalidXmlException
    extends IOException {
        private Throwable cause;

        public InvalidXmlException(String message, Throwable cause) {
            super(message);
            this.cause = cause;
        }

        public Throwable getCause() {
            return this.cause;
        }
    }
}

