/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.InterThreadException;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPExtendedOperation;
import com.novell.ldap.LDAPExtendedRequest;
import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPSocketFactory;
import com.novell.ldap.LDAPTLSSocketFactory;
import com.novell.ldap.LDAPUnbindRequest;
import com.novell.ldap.LDAPUnsolicitedNotificationListener;
import com.novell.ldap.Message;
import com.novell.ldap.MessageAgent;
import com.novell.ldap.MessageVector;
import com.novell.ldap.asn1.ASN1Identifier;
import com.novell.ldap.asn1.ASN1Length;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.asn1.LBEREncoder;
import com.novell.ldap.client.BindProperties;
import com.novell.ldap.client.ReferralInfo;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;

final class Connection {
    private Object writeSemaphore = new Object();
    private int writeSemaphoreOwner = 0;
    private int writeSemaphoreCount = 0;
    private int ephemeralId = -1;
    private BindProperties bindProperties = null;
    private int bindSemaphoreId = 0;
    private Thread reader = null;
    private Thread deadReader = null;
    private IOException deadReaderException = null;
    private LBEREncoder encoder = new LBEREncoder();
    private LBERDecoder decoder = new LBERDecoder();
    private Socket socket = null;
    private Socket nonTLSBackup = null;
    private InputStream in = null;
    private OutputStream out = null;
    private boolean clientActive = true;
    private boolean unsolSvrShutDnNotification = false;
    private static final int CONTINUE_READING = -99;
    private static final int STOP_READING = -98;
    private int stopReaderMessageID = -99;
    private MessageVector messages = new MessageVector(5, 5);
    private ReferralInfo activeReferral = null;
    private Vector unsolicitedListeners = new Vector(3, 3);
    private static LDAPSocketFactory socketFactory = null;
    private LDAPSocketFactory mySocketFactory;
    private int myTimeOut = 0;
    private String host = null;
    private int port = 0;
    private int cloneCount = 0;
    private String name = "";
    private static Object nameLock = new Object();
    private static int connNum = 0;
    static String sdk = new String("4.3");
    static Integer protocol = new Integer(3);
    static String security = "simple";

    Connection(LDAPSocketFactory lDAPSocketFactory) {
        if (lDAPSocketFactory != null) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkSetFactory();
            }
            this.mySocketFactory = lDAPSocketFactory;
        } else {
            this.mySocketFactory = socketFactory;
        }
    }

    Object copy() {
        Connection connection = new Connection(this.mySocketFactory);
        connection.host = this.host;
        connection.port = this.port;
        return connection;
    }

    Connection(int n) {
        this.myTimeOut = n;
    }

    Object copy_timeout() {
        Connection connection = new Connection(this.myTimeOut);
        connection.host = this.host;
        connection.port = this.port;
        return connection;
    }

    final int acquireWriteSemaphore() {
        return this.acquireWriteSemaphore(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int acquireWriteSemaphore(int n) {
        int n2 = n;
        Object object = this.writeSemaphore;
        synchronized (object) {
            if (n2 == 0) {
                n2 = this.ephemeralId = this.ephemeralId == Integer.MIN_VALUE ? (this.ephemeralId = -1) : (this.ephemeralId = this.ephemeralId - 1);
            }
            while (true) {
                if (this.writeSemaphoreOwner == 0) {
                    this.writeSemaphoreOwner = n2;
                    break;
                }
                if (this.writeSemaphoreOwner == n2) break;
                try {
                    this.writeSemaphore.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            ++this.writeSemaphoreCount;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void freeWriteSemaphore(int n) {
        Object object = this.writeSemaphore;
        synchronized (object) {
            if (this.writeSemaphoreOwner == 0) {
                throw new RuntimeException("Connection.freeWriteSemaphore(" + n + "): semaphore not owned by any thread");
            }
            if (this.writeSemaphoreOwner != n) {
                throw new RuntimeException("Connection.freeWriteSemaphore(" + n + "): thread does not own the semaphore, owned by " + this.writeSemaphoreOwner);
            }
            if (--this.writeSemaphoreCount == 0) {
                this.writeSemaphoreOwner = 0;
                this.writeSemaphore.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForReader(Thread thread) throws LDAPException {
        while (this.reader != thread) {
            try {
                Object object;
                if (thread == this.deadReader) {
                    if (thread == null) {
                        return;
                    }
                    object = this.deadReaderException;
                    this.deadReaderException = null;
                    this.deadReader = null;
                    throw new LDAPException("CONNECTION_READER", 91, null, (Throwable)object);
                }
                object = this;
                synchronized (object) {
                    this.wait(5L);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        this.deadReaderException = null;
        this.deadReader = null;
    }

    void connect(String string, int n) throws LDAPException {
        this.connect(string, n, 0);
    }

    private void connect(String string, int n, int n2) throws LDAPException {
        this.waitForReader(null);
        this.unsolSvrShutDnNotification = false;
        int n3 = this.acquireWriteSemaphore(n2);
        if (n == 0) {
            n = 389;
        }
        try {
            if (this.in == null || this.out == null) {
                if (this.mySocketFactory != null) {
                    this.socket = this.mySocketFactory.createSocket(string, n);
                } else {
                    this.socket = new Socket(string, n);
                    if (this.myTimeOut > 0) {
                        this.socket.setSoTimeout(this.myTimeOut);
                    }
                }
                this.in = this.socket.getInputStream();
                this.out = this.socket.getOutputStream();
            }
        }
        catch (IOException iOException) {
            this.freeWriteSemaphore(n3);
            throw new LDAPException("CONNECTION_ERROR", new Object[]{string, new Integer(n)}, 91, null, iOException);
        }
        this.host = string;
        this.port = n;
        this.startReader();
        this.freeWriteSemaphore(n3);
        this.clientActive = true;
    }

    final boolean isCloned() {
        return this.cloneCount > 0;
    }

    final synchronized void incrCloneCount() {
        ++this.cloneCount;
    }

    final synchronized Connection destroyClone(boolean bl) {
        Connection connection = this;
        if (this.cloneCount > 0) {
            --this.cloneCount;
            connection = bl ? (Connection)this.copy() : null;
        } else if (this.in != null) {
            InterThreadException interThreadException = new InterThreadException(bl ? "CONNECTION_CLOSED" : "CONNECTION_FINALIZED", null, 91, null, null);
            this.shutdown("destroy clone", 0, interThreadException);
        }
        return connection;
    }

    static final void setSocketFactory(LDAPSocketFactory lDAPSocketFactory) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        socketFactory = lDAPSocketFactory;
    }

    final LDAPSocketFactory getSocketFactory() {
        return this.mySocketFactory;
    }

    final String getHost() {
        return this.host;
    }

    final int getPort() {
        return this.port;
    }

    int getBindSemId() {
        return this.bindSemaphoreId;
    }

    void setBindSemId(int n) {
        this.bindSemaphoreId = n;
    }

    void clearBindSemId() {
        this.bindSemaphoreId = 0;
    }

    final int getSocketTimeOut() {
        return this.myTimeOut;
    }

    final void setSocketTimeOut(int n) {
        try {
            this.socket.setSoTimeout(n);
            this.myTimeOut = n;
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    boolean isBindSemIdClear() {
        return this.bindSemaphoreId == 0;
    }

    void writeMessage(Message message) throws LDAPException {
        this.messages.addElement(message);
        if (message.isBindRequest() && !this.isConnected() && this.host != null) {
            this.connect(this.host, this.port, message.getMessageID());
        }
        LDAPMessage lDAPMessage = message.getRequest();
        this.writeMessage(lDAPMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeMessage(LDAPMessage lDAPMessage) throws LDAPException {
        int n = this.bindSemaphoreId == 0 ? lDAPMessage.getMessageID() : this.bindSemaphoreId;
        OutputStream outputStream = this.out;
        this.acquireWriteSemaphore(n);
        try {
            if (outputStream == null) {
                throw new IOException("Output stream not initialized");
            }
            byte[] byArray = lDAPMessage.getASN1Object().getEncoding(this.encoder);
            outputStream.write(byArray, 0, byArray.length);
            outputStream.flush();
        }
        catch (IOException iOException) {
            if (this.clientActive) {
                if (this.unsolSvrShutDnNotification) {
                    throw new LDAPException("SERVER_SHUTDOWN_REQ", new Object[]{this.host, new Integer(this.port)}, 91, null, iOException);
                }
                throw new LDAPException("IO_EXCEPTION", new Object[]{this.host, new Integer(this.port)}, 91, null, iOException);
            }
        }
        finally {
            this.freeWriteSemaphore(n);
        }
    }

    final MessageAgent getMessageAgent(int n) throws NoSuchFieldException {
        Message message = this.messages.findMessageById(n);
        return message.getMessageAgent();
    }

    final boolean isBound() {
        if (this.bindProperties != null) {
            return !this.bindProperties.isAnonymous();
        }
        return false;
    }

    final boolean isConnected() {
        return this.in != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isConnectionAlive() {
        boolean bl = false;
        LDAPExtendedOperation lDAPExtendedOperation = null;
        if (this.in != null) {
            bl = true;
            lDAPExtendedOperation = new LDAPExtendedOperation("0.0.0.0", null);
            LDAPExtendedRequest lDAPExtendedRequest = new LDAPExtendedRequest(lDAPExtendedOperation, null);
            int n = lDAPExtendedRequest.getMessageID();
            this.acquireWriteSemaphore(n);
            OutputStream outputStream = this.out;
            try {
                if (outputStream == null) {
                    throw new IOException("Output stream not initialized");
                }
                byte[] byArray = lDAPExtendedRequest.getASN1Object().getEncoding(this.encoder);
                outputStream.write(byArray, 0, byArray.length);
                outputStream.flush();
            }
            catch (IOException iOException) {
                bl = false;
            }
            finally {
                this.freeWriteSemaphore(n);
            }
        }
        return bl;
    }

    final void removeMessage(Message message) {
        boolean bl = this.messages.removeElement(message);
    }

    protected void finalize() {
        this.shutdown("Finalize", 0, null);
    }

    private void shutdown(String string, int n, InterThreadException interThreadException) {
        Message message = null;
        if (!this.clientActive) {
            return;
        }
        this.clientActive = false;
        while (true) {
            try {
                message = (Message)this.messages.remove(0);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                break;
            }
            message.abandon(null, interThreadException);
        }
        int n2 = this.acquireWriteSemaphore(n);
        if (this.bindProperties != null && this.out != null && !this.bindProperties.isAnonymous()) {
            try {
                LDAPUnbindRequest lDAPUnbindRequest = new LDAPUnbindRequest(null);
                byte[] byArray = lDAPUnbindRequest.getASN1Object().getEncoding(this.encoder);
                this.out.write(byArray, 0, byArray.length);
                this.out.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.bindProperties = null;
        this.in = null;
        this.out = null;
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
        try {
            if (this.reader != Thread.currentThread()) {
                this.reader.join();
            }
            this.reader = null;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.freeWriteSemaphore(n2);
    }

    final void setBindProperties(BindProperties bindProperties) {
        this.bindProperties = bindProperties;
    }

    final BindProperties getBindProperties() {
        return this.bindProperties;
    }

    final boolean areMessagesComplete() {
        Object[] objectArray = this.messages.getObjectArray();
        int n = objectArray.length;
        if (this.bindSemaphoreId != 0) {
            return false;
        }
        if (n == 0) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            if (((Message)objectArray[i]).isComplete()) continue;
            return false;
        }
        return true;
    }

    final void stopReaderOnReply(int n) {
        this.stopReaderMessageID = n;
    }

    final void startReader() throws LDAPException {
        Thread thread = new Thread(new ReaderThread());
        thread.setDaemon(true);
        thread.start();
        this.waitForReader(thread);
    }

    final boolean isTLS() {
        return this.nonTLSBackup != null;
    }

    final void startTLS() throws LDAPException {
        if (this.mySocketFactory == null) {
            throw new LDAPException("NO_TLS_FACTORY", 112, null);
        }
        if (!(this.mySocketFactory instanceof LDAPTLSSocketFactory)) {
            throw new LDAPException("WRONG_FACTORY", 112, null);
        }
        try {
            this.waitForReader(null);
            this.nonTLSBackup = this.socket;
            this.socket = ((LDAPTLSSocketFactory)this.mySocketFactory).createSocket(this.socket);
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
        }
        catch (UnknownHostException unknownHostException) {
            this.nonTLSBackup = null;
            throw new LDAPException("The host is unknown", 91, null, unknownHostException);
        }
        catch (IOException iOException) {
            this.nonTLSBackup = null;
            throw new LDAPException("Could not negotiate a secure connection", 91, null, iOException);
        }
    }

    final void stopTLS() throws LDAPException {
        try {
            this.stopReaderMessageID = -98;
            this.socket.close();
            this.waitForReader(null);
            this.socket = this.nonTLSBackup;
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
            this.stopReaderMessageID = -99;
        }
        catch (IOException iOException) {
            throw new LDAPException("STOPTLS_ERROR", 91, null, iOException);
        }
        finally {
            this.nonTLSBackup = null;
            this.startReader();
        }
    }

    final void setActiveReferral(ReferralInfo referralInfo) {
        this.activeReferral = referralInfo;
    }

    final ReferralInfo getActiveReferral() {
        return this.activeReferral;
    }

    final void addUnsolicitedNotificationListener(LDAPUnsolicitedNotificationListener lDAPUnsolicitedNotificationListener) {
        this.unsolicitedListeners.add(lDAPUnsolicitedNotificationListener);
    }

    final void removeUnsolicitedNotificationListener(LDAPUnsolicitedNotificationListener lDAPUnsolicitedNotificationListener) {
        this.unsolicitedListeners.removeElement(lDAPUnsolicitedNotificationListener);
    }

    private void notifyAllUnsolicitedListeners(RfcLDAPMessage rfcLDAPMessage) {
        LDAPExtendedResponse lDAPExtendedResponse = new LDAPExtendedResponse(rfcLDAPMessage);
        String string = lDAPExtendedResponse.getID();
        if (string.equals("1.3.6.1.4.1.1466.20036")) {
            this.unsolSvrShutDnNotification = true;
        }
        int n = this.unsolicitedListeners.size();
        for (int i = 0; i < n; ++i) {
            LDAPUnsolicitedNotificationListener lDAPUnsolicitedNotificationListener = (LDAPUnsolicitedNotificationListener)this.unsolicitedListeners.get(i);
            LDAPExtendedResponse lDAPExtendedResponse2 = new LDAPExtendedResponse(rfcLDAPMessage);
            UnsolicitedListenerThread unsolicitedListenerThread = new UnsolicitedListenerThread(lDAPUnsolicitedNotificationListener, lDAPExtendedResponse2);
            unsolicitedListenerThread.start();
        }
    }

    String getConnectionName() {
        return this.name;
    }

    private class UnsolicitedListenerThread
    extends Thread {
        private LDAPUnsolicitedNotificationListener listenerObj;
        private LDAPExtendedResponse unsolicitedMsg;

        UnsolicitedListenerThread(LDAPUnsolicitedNotificationListener lDAPUnsolicitedNotificationListener, LDAPExtendedResponse lDAPExtendedResponse) {
            this.listenerObj = lDAPUnsolicitedNotificationListener;
            this.unsolicitedMsg = lDAPExtendedResponse;
        }

        public final void run() {
            this.listenerObj.messageReceived(this.unsolicitedMsg);
        }
    }

    public class ReaderThread
    implements Runnable {
        private ReaderThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void run() {
            IOException iOException;
            block17: {
                InterThreadException interThreadException;
                String string;
                block15: {
                    block16: {
                        string = "reader: thread stopping";
                        interThreadException = null;
                        Message message = null;
                        iOException = null;
                        Connection.this.reader = Thread.currentThread();
                        try {
                            InputStream inputStream;
                            while ((inputStream = Connection.this.in) != null) {
                                int n;
                                block14: {
                                    ASN1Identifier aSN1Identifier = new ASN1Identifier(inputStream);
                                    int n2 = aSN1Identifier.getTag();
                                    if (aSN1Identifier.getTag() != 16) continue;
                                    ASN1Length aSN1Length = new ASN1Length(inputStream);
                                    RfcLDAPMessage rfcLDAPMessage = new RfcLDAPMessage(Connection.this.decoder, inputStream, aSN1Length.getLength());
                                    n = rfcLDAPMessage.getMessageID();
                                    try {
                                        message = Connection.this.messages.findMessageById(n);
                                        message.putReply(rfcLDAPMessage);
                                    }
                                    catch (NoSuchFieldException noSuchFieldException) {
                                        if (n != 0) break block14;
                                        Connection.this.notifyAllUnsolicitedListeners(rfcLDAPMessage);
                                        if (!Connection.this.unsolSvrShutDnNotification) break block14;
                                        interThreadException = new InterThreadException("SERVER_SHUTDOWN_REQ", new Object[]{Connection.this.host, new Integer(Connection.this.port)}, 91, null, null);
                                        if (Connection.this.clientActive && interThreadException == null) {
                                            Connection.this.stopReaderMessageID = -99;
                                            return;
                                        }
                                        Connection.this.shutdown(string, 0, interThreadException);
                                        return;
                                    }
                                }
                                if (Connection.this.stopReaderMessageID != n && Connection.this.stopReaderMessageID != -98) continue;
                                if (Connection.this.clientActive && interThreadException == null) break block15;
                                break block16;
                            }
                            break block17;
                        }
                        catch (IOException iOException2) {
                            iOException = iOException2;
                            if (Connection.this.stopReaderMessageID != -98 && Connection.this.clientActive) {
                                interThreadException = new InterThreadException("CONNECTION_WAIT", new Object[]{Connection.this.host, new Integer(Connection.this.port)}, 91, iOException2, message);
                            }
                            Connection.this.in = null;
                            Connection.this.out = null;
                            break block17;
                        }
                    }
                    Connection.this.shutdown(string, 0, interThreadException);
                    return;
                }
                Connection.this.stopReaderMessageID = -99;
                return;
                finally {
                    if (!Connection.this.clientActive || interThreadException != null) {
                        Connection.this.shutdown(string, 0, interThreadException);
                    } else {
                        Connection.this.stopReaderMessageID = -99;
                    }
                }
            }
            Connection.this.deadReaderException = iOException;
            Connection.this.deadReader = Connection.this.reader;
            Connection.this.reader = null;
        }
    }
}

