/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.DSMLSearchResults;
import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPConstraints;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPDeleteRequest;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPLocalException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPMessageQueue;
import com.novell.ldap.LDAPModification;
import com.novell.ldap.LDAPModifyDNRequest;
import com.novell.ldap.LDAPResponseQueue;
import com.novell.ldap.LDAPSearchConstraints;
import com.novell.ldap.LDAPSearchQueue;
import com.novell.ldap.LDAPSearchRequest;
import com.novell.ldap.LDAPSearchResults;
import com.novell.ldap.LDAPSocketFactory;
import com.novell.ldap.SPMLSearchResults;
import com.novell.ldap.rfc2251.RfcFilter;
import com.novell.ldap.spml.SPMLImpl;
import com.novell.ldap.util.Base64;
import com.novell.ldap.util.DN;
import com.novell.ldap.util.HttpRequestCallback;
import com.novell.ldap.util.RDN;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.openspml.client.SpmlClient;
import org.openspml.message.AddRequest;
import org.openspml.message.Attribute;
import org.openspml.message.FilterTerm;
import org.openspml.message.Identifier;
import org.openspml.message.Modification;
import org.openspml.message.ModifyRequest;
import org.openspml.message.ModifyResponse;
import org.openspml.message.SearchRequest;
import org.openspml.message.SearchResponse;
import org.openspml.message.SpmlRequest;
import org.openspml.util.SpmlException;

public class SPMLConnection
extends LDAPConnection {
    public static final String DEF_IMPL = "com.novell.ldap.spml.SunIdm";
    SpmlClient con;
    SPMLImpl vendorImpl;
    String serverString;
    String binddn;
    String pass;
    boolean isBound;
    boolean isConnected;
    private String host;
    HttpRequestCallback callback;
    static /* synthetic */ Class class$org$openspml$message$Identifier;

    private LDAPMessage sendMessage(LDAPMessage lDAPMessage) throws LDAPException {
        return null;
    }

    private DSMLSearchResults execQuery(LDAPMessage lDAPMessage) throws LDAPException {
        return null;
    }

    public SPMLConnection() {
        this.loadImpl(DEF_IMPL, null);
    }

    public SPMLConnection(String string) {
        this.loadImpl(string, null);
    }

    public SPMLConnection(String string, ClassLoader classLoader) {
        this.loadImpl(string, classLoader);
    }

    public SPMLConnection(LDAPSocketFactory lDAPSocketFactory) {
        this();
    }

    private void loadImpl(String string, ClassLoader classLoader) {
        SPMLImpl sPMLImpl = null;
        if (classLoader == null) {
            try {
                sPMLImpl = (SPMLImpl)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                return;
            }
        }
        try {
            sPMLImpl = (SPMLImpl)classLoader.loadClass(string).newInstance();
        }
        catch (Exception exception) {
            return;
        }
        this.vendorImpl = sPMLImpl;
        this.con = sPMLImpl.getSpmlClient();
    }

    public void connect(String string, int n) throws LDAPException {
        this.serverString = string;
        this.host = string.substring(string.indexOf("//") + 2, string.indexOf("/", string.indexOf("//") + 2));
        try {
            this.con.setUrl(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new LDAPLocalException(malformedURLException.toString(), 53, malformedURLException);
        }
        this.isConnected = true;
    }

    public void bind(int n, String string, byte[] byArray, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.bind(string, new String(byArray));
    }

    public LDAPResponseQueue bind(int n, String string, byte[] byArray, LDAPResponseQueue lDAPResponseQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        return null;
    }

    public LDAPResponseQueue bind(int n, String string, byte[] byArray, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        return null;
    }

    public void bind(int n, String string, byte[] byArray) throws LDAPException {
        this.bind(string, new String(byArray));
    }

    public void bind(int n, String string, String string2, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.bind(string, new String(string2));
    }

    public void bind(int n, String string, String string2) throws LDAPException {
        this.bind(string, new String(string2));
    }

    public void bind(String string, String string2, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.bind(string, new String(string2));
    }

    public void bind(String string, String string2, Map map, Object object, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.bind(string, new String(string2));
    }

    public void bind(String string, String string2, Map map, Object object) throws LDAPException {
        this.bind(string, new String(string2));
    }

    public void bind(String string, String string2, String[] stringArray, Map map, Object object, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.bind(string, new String(string2));
    }

    public void bind(String string, String string2, String[] stringArray, Map map, Object object) throws LDAPException {
        this.bind(string, new String(this.pass));
    }

    public void bind(String string, String string2) throws LDAPException {
        if (this.isBound) {
            this.vendorImpl.logout();
        }
        this.isBound = false;
        this.vendorImpl.login(string, string2);
        this.isBound = true;
    }

    public void add(LDAPEntry lDAPEntry, LDAPConstraints lDAPConstraints) throws LDAPException {
        List<String> list;
        Object object;
        LDAPAttribute lDAPAttribute;
        AddRequest addRequest = new AddRequest();
        DN dN = new DN(lDAPEntry.getDN());
        RDN rDN = (RDN)dN.getRDNs().get(0);
        Identifier identifier = new Identifier();
        try {
            identifier.setType(this.getIdentifierType(rDN.getType()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new LDAPException("Could not determine type", 53, illegalArgumentException.toString(), illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new LDAPException("Could not determine type", 53, illegalAccessException.toString(), illegalAccessException);
        }
        identifier.setId(rDN.getValue());
        String string = lDAPEntry.getAttribute("objectClass").getStringValue();
        addRequest.setObjectClass(string);
        Iterator iterator = lDAPEntry.getAttributeSet().iterator();
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        while (iterator.hasNext()) {
            lDAPAttribute = (LDAPAttribute)iterator.next();
            if (lDAPAttribute.getName().toLowerCase().equals("objectclass")) continue;
            object = lDAPAttribute.getStringValueArray();
            list = new ArrayList();
            int n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                ((ArrayList)list).add(object[i]);
            }
            hashMap.put(lDAPAttribute.getName(), list);
        }
        addRequest.setAttributes(hashMap);
        addRequest.setIdentifier(identifier);
        try {
            lDAPAttribute = this.con.request((SpmlRequest)addRequest);
            if (lDAPAttribute.getResult().equals("urn:oasis:names:tc:SPML:1:0#pending")) {
                object = "";
                list = lDAPAttribute.getOperationalAttributes();
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    Attribute attribute = (Attribute)iterator.next();
                    object = (String)object + "[" + attribute.getName() + "=" + attribute.getValue() + "] ";
                }
                throw new LDAPLocalException((String)object, 0);
            }
            if (!lDAPAttribute.getResult().equals("urn:oasis:names:tc:SPML:1:0#success")) {
                System.out.println("Response : " + lDAPAttribute.getResult());
                throw new LDAPLocalException(lDAPAttribute.getErrorMessage(), 53);
            }
        }
        catch (SpmlException spmlException) {
            throw new LDAPException(spmlException.toString(), 53, spmlException.toString());
        }
    }

    public LDAPResponseQueue add(LDAPEntry lDAPEntry, LDAPResponseQueue lDAPResponseQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        return null;
    }

    public LDAPResponseQueue add(LDAPEntry lDAPEntry, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        return null;
    }

    public void add(LDAPEntry lDAPEntry) throws LDAPException {
        this.add(lDAPEntry, (LDAPConstraints)null);
    }

    public void modify(String string, LDAPModification lDAPModification, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.modify(string, new LDAPModification[]{lDAPModification}, lDAPConstraints);
    }

    public LDAPResponseQueue modify(String string, LDAPModification lDAPModification, LDAPResponseQueue lDAPResponseQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        return null;
    }

    public LDAPResponseQueue modify(String string, LDAPModification lDAPModification, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        return null;
    }

    public void modify(String string, LDAPModification lDAPModification) throws LDAPException {
        this.modify(string, new LDAPModification[]{lDAPModification}, (LDAPConstraints)null);
    }

    public void modify(String string, LDAPModification[] lDAPModificationArray, LDAPConstraints lDAPConstraints) throws LDAPException {
        LDAPControl[] lDAPControlArray = lDAPConstraints != null ? lDAPConstraints.getControls() : null;
        ModifyRequest modifyRequest = new ModifyRequest();
        DN dN = new DN(string);
        RDN rDN = (RDN)dN.getRDNs().get(0);
        Identifier identifier = new Identifier();
        try {
            identifier.setType(this.getIdentifierType(rDN.getType()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new LDAPException("Could not determine type", 53, illegalArgumentException.toString(), illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new LDAPException("Could not determine type", 53, illegalAccessException.toString(), illegalAccessException);
        }
        modifyRequest.setIdentifier(identifier);
        identifier.setId(rDN.getValue());
        Modification modification = null;
        int n = lDAPModificationArray.length;
        for (int i = 0; i < n; ++i) {
            modification = new Modification();
            modification.setName(lDAPModificationArray[i].getAttribute().getName());
            ArrayList arrayList = new ArrayList();
            Enumeration enumeration = lDAPModificationArray[i].getAttribute().getStringValues();
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
            modification.setValue(arrayList);
            int n2 = lDAPModificationArray[i].getOp();
            switch (n2) {
                case 0: {
                    modification.setOperation("add");
                    break;
                }
                case 2: {
                    modification.setOperation("replace");
                    break;
                }
                case 1: {
                    modification.setOperation("delete");
                }
            }
            modifyRequest.addModification(modification);
        }
        try {
            ModifyResponse modifyResponse = (ModifyResponse)this.con.request((SpmlRequest)modifyRequest);
            if (!modifyResponse.getResult().equals("urn:oasis:names:tc:SPML:1:0#success")) {
                throw new LDAPLocalException(modifyResponse.getErrorMessage(), 53);
            }
        }
        catch (SpmlException spmlException) {
            throw new LDAPException(spmlException.toString(), 53, spmlException.toString());
        }
    }

    public LDAPResponseQueue modify(String string, LDAPModification[] lDAPModificationArray, LDAPResponseQueue lDAPResponseQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        return null;
    }

    public LDAPResponseQueue modify(String string, LDAPModification[] lDAPModificationArray, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        return null;
    }

    public void modify(String string, LDAPModification[] lDAPModificationArray) throws LDAPException {
        this.modify(string, lDAPModificationArray, (LDAPConstraints)null);
    }

    public void rename(String string, String string2, boolean bl, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.rename(string, string2, "", bl, lDAPConstraints);
    }

    public LDAPResponseQueue rename(String string, String string2, boolean bl, LDAPResponseQueue lDAPResponseQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        return null;
    }

    public LDAPResponseQueue rename(String string, String string2, boolean bl, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        return null;
    }

    public void rename(String string, String string2, boolean bl) throws LDAPException {
        this.rename(string, string2, "", bl, (LDAPConstraints)null);
    }

    public void rename(String string, String string2, String string3, boolean bl, LDAPConstraints lDAPConstraints) throws LDAPException {
        LDAPControl[] lDAPControlArray = lDAPConstraints != null ? lDAPConstraints.getControls() : null;
        LDAPModifyDNRequest lDAPModifyDNRequest = new LDAPModifyDNRequest(string, string2, string3, bl, lDAPControlArray);
        this.sendMessage(lDAPModifyDNRequest);
    }

    public LDAPResponseQueue rename(String string, String string2, String string3, boolean bl, LDAPResponseQueue lDAPResponseQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        return null;
    }

    public LDAPResponseQueue rename(String string, String string2, String string3, boolean bl, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        return null;
    }

    public void rename(String string, String string2, String string3, boolean bl) throws LDAPException {
        this.rename(string, string2, string3, bl, (LDAPConstraints)null);
    }

    public void delete(String string, LDAPConstraints lDAPConstraints) throws LDAPException {
        LDAPControl[] lDAPControlArray = lDAPConstraints != null ? lDAPConstraints.getControls() : null;
        LDAPDeleteRequest lDAPDeleteRequest = new LDAPDeleteRequest(string, lDAPControlArray);
        this.sendMessage(lDAPDeleteRequest);
    }

    public LDAPResponseQueue delete(String string, LDAPResponseQueue lDAPResponseQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        return null;
    }

    public LDAPResponseQueue delete(String string, LDAPResponseQueue lDAPResponseQueue) throws LDAPException {
        return null;
    }

    public void delete(String string) throws LDAPException {
        this.delete(string, (LDAPConstraints)null);
    }

    public LDAPSearchResults search(String string, int n, String string2, String[] stringArray, boolean bl, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        SearchResponse searchResponse;
        FilterTerm filterTerm;
        Object object;
        LDAPControl[] lDAPControlArray = lDAPSearchConstraints != null ? lDAPSearchConstraints.getControls() : null;
        LDAPSearchRequest lDAPSearchRequest = new LDAPSearchRequest(string, n, string2, stringArray, 0, 0, 0, bl, lDAPControlArray);
        SearchRequest searchRequest = new SearchRequest();
        if (string != null && string.trim().length() != 0) {
            object = new DN(string);
            if (!(string.toLowerCase().startsWith("ou") || string.toLowerCase().startsWith("dc") || string.toLowerCase().startsWith("o"))) {
                if (n == 0) {
                    filterTerm = new Identifier();
                    try {
                        filterTerm.setType(this.getIdentifierType(((RDN)((DN)object).getRDNs().get(0)).getType()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new LDAPException("Could not determine type", 53, illegalArgumentException.toString(), illegalArgumentException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new LDAPException("Could not determine type", 53, illegalAccessException.toString(), illegalAccessException);
                    }
                    filterTerm.setId(((DN)object).explodeDN(true)[0]);
                    searchRequest.setSearchBase((Identifier)filterTerm);
                } else {
                    searchRequest.setSearchBase(string);
                }
            } else if (n == 0) {
                return new SPMLSearchResults(new ArrayList());
            }
        }
        if (string2 != null && !string2.trim().equalsIgnoreCase("objectClass=*") && !string2.trim().equalsIgnoreCase("(objectClass=*)")) {
            object = new RfcFilter(string2.trim());
            filterTerm = new FilterTerm();
            System.out.println("part : " + filterTerm.getOperation());
            this.stringFilter(((RfcFilter)object).getFilterIterator(), filterTerm);
            searchRequest.addFilterTerm(filterTerm);
        }
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            searchRequest.addAttribute(stringArray[i]);
        }
        try {
            searchResponse = this.con.searchRequest(searchRequest);
        }
        catch (SpmlException spmlException) {
            throw new LDAPException("Could not search", 53, spmlException.toString());
        }
        return new SPMLSearchResults(searchResponse.getResults() != null ? searchResponse.getResults() : new ArrayList());
    }

    public LDAPSearchQueue search(String string, int n, String string2, String[] stringArray, boolean bl, LDAPSearchQueue lDAPSearchQueue, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        return null;
    }

    public LDAPSearchQueue search(String string, int n, String string2, String[] stringArray, boolean bl, LDAPSearchQueue lDAPSearchQueue) throws LDAPException {
        return null;
    }

    public LDAPSearchResults search(String string, int n, String string2, String[] stringArray, boolean bl) throws LDAPException {
        return this.search(string, n, string2, stringArray, bl, (LDAPSearchConstraints)null);
    }

    public boolean isConnectionAlive() {
        return true;
    }

    public boolean isBound() {
        return this.isBound;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public boolean isTLS() {
        return this.serverString.toLowerCase().startsWith("https");
    }

    public void disconnect() throws LDAPException {
        this.serverString = null;
        this.isConnected = false;
    }

    public void disconnect(LDAPConstraints lDAPConstraints) throws LDAPException {
        this.disconnect();
    }

    public LDAPMessageQueue sendRequest(LDAPMessage lDAPMessage, LDAPMessageQueue lDAPMessageQueue) throws LDAPException {
        this.sendMessage(lDAPMessage);
        return null;
    }

    public HttpRequestCallback getCallback() {
        return this.callback;
    }

    public void setCallback(HttpRequestCallback httpRequestCallback) {
        this.callback = httpRequestCallback;
    }

    public String getBinddn() {
        return this.binddn;
    }

    public HttpClient getCon() {
        return null;
    }

    public String getHost() {
        return this.host;
    }

    public String getPass() {
        return this.pass;
    }

    public String getServerString() {
        return this.serverString;
    }

    private String getIdentifierType(String string) throws IllegalArgumentException, IllegalAccessException {
        Field[] fieldArray = (class$org$openspml$message$Identifier == null ? (class$org$openspml$message$Identifier = SPMLConnection.class$("org.openspml.message.Identifier")) : class$org$openspml$message$Identifier).getFields();
        int n = fieldArray.length;
        for (int i = 0; i < n; ++i) {
            if (!fieldArray[i].getName().startsWith("TYPE") || !fieldArray[i].get(null).toString().endsWith(string)) continue;
            return fieldArray[i].get(null).toString();
        }
        return "";
    }

    private static String byteString(byte[] byArray) {
        String string = null;
        if (Base64.isValidUTF8(byArray, true)) {
            try {
                string = new String(byArray, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException("Default JVM does not support UTF-8 encoding" + unsupportedEncodingException);
            }
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] >= 0) {
                    stringBuffer.append("\\0");
                    stringBuffer.append(Integer.toHexString(byArray[i]));
                    continue;
                }
                stringBuffer.append("\\" + Integer.toHexString(byArray[i]).substring(6));
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    private void stringFilter(Iterator iterator, FilterTerm object) {
        int n = -1;
        Object var4_4 = null;
        boolean bl = false;
        boolean bl2 = true;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Integer) {
                n = (Integer)e;
                switch (n) {
                    case 0: {
                        String string;
                        if (object.getOperation() != null) {
                            string = new FilterTerm();
                            string.setOperation("and");
                            object.addOperand((FilterTerm)string);
                            object = string;
                            break;
                        }
                        object.setOperation("and");
                        break;
                    }
                    case 1: {
                        String string;
                        if (object.getOperation() != null) {
                            string = new FilterTerm();
                            string.setOperation("or");
                            object.addOperand((FilterTerm)string);
                            object = string;
                            break;
                        }
                        if (object.getOperation() != null) break;
                        object.setOperation("or");
                        break;
                    }
                    case 2: {
                        String string;
                        if (object.getOperation() != null) {
                            string = new FilterTerm();
                            string.setOperation("not");
                            object.addOperand((FilterTerm)string);
                            object = string;
                            break;
                        }
                        object.setOperation("not");
                        break;
                    }
                    case 3: {
                        FilterTerm filterTerm;
                        if (object.getOperation() == null) {
                            filterTerm = object;
                        } else {
                            filterTerm = new FilterTerm();
                            bl = true;
                        }
                        filterTerm.setName((String)iterator.next());
                        filterTerm.setOperation("equalityMatch");
                        byte[] byArray = (byte[])iterator.next();
                        filterTerm.setValue((Object)SPMLConnection.byteString(byArray));
                        if (!bl) break;
                        object.addOperand(filterTerm);
                        break;
                    }
                    case 5: {
                        FilterTerm filterTerm;
                        if (object.getOperation() == null) {
                            filterTerm = object;
                        } else {
                            filterTerm = new FilterTerm();
                            bl = true;
                        }
                        filterTerm.setName((String)iterator.next());
                        filterTerm.setOperation("greaterOrEqual");
                        byte[] byArray = (byte[])iterator.next();
                        filterTerm.setValue((Object)SPMLConnection.byteString(byArray));
                        if (!bl) break;
                        object.addOperand(filterTerm);
                        break;
                    }
                    case 6: {
                        FilterTerm filterTerm;
                        if (object.getOperation() == null) {
                            filterTerm = object;
                        } else {
                            filterTerm = new FilterTerm();
                            bl = true;
                        }
                        filterTerm.setName((String)iterator.next());
                        filterTerm.setOperation("lessOrEqual");
                        byte[] byArray = (byte[])iterator.next();
                        filterTerm.setValue((Object)SPMLConnection.byteString(byArray));
                        if (!bl) break;
                        object.addOperand(filterTerm);
                        break;
                    }
                    case 7: {
                        FilterTerm filterTerm;
                        if (object.getOperation() == null) {
                            filterTerm = object;
                        } else {
                            filterTerm = new FilterTerm();
                            bl = true;
                        }
                        filterTerm.setName((String)iterator.next());
                        filterTerm.setOperation("present");
                        if (!bl) break;
                        object.addOperand(filterTerm);
                        break;
                    }
                    case 8: {
                        FilterTerm filterTerm;
                        if (object.getOperation() == null) {
                            filterTerm = object;
                        } else {
                            filterTerm = new FilterTerm();
                            bl = true;
                        }
                        filterTerm.setName((String)iterator.next());
                        filterTerm.setOperation("approxMatch");
                        byte[] byArray = (byte[])iterator.next();
                        filterTerm.setValue((Object)SPMLConnection.byteString(byArray));
                        if (!bl) break;
                        object.addOperand(filterTerm);
                        break;
                    }
                    case 9: {
                        FilterTerm filterTerm;
                        String string = (String)iterator.next();
                        if (object.getOperation() == null) {
                            filterTerm = object;
                        } else {
                            filterTerm = new FilterTerm();
                            bl = true;
                        }
                        filterTerm.setName((String)iterator.next() + ":" + string);
                        filterTerm.setOperation("extensibleMatch");
                        byte[] byArray = (byte[])iterator.next();
                        filterTerm.setValue((Object)SPMLConnection.byteString(byArray));
                        if (!bl) break;
                        object.addOperand(filterTerm);
                        break;
                    }
                    case 4: {
                        FilterTerm filterTerm;
                        if (object.getOperation() == null) {
                            filterTerm = object;
                        } else {
                            filterTerm = new FilterTerm();
                            bl = true;
                        }
                        filterTerm.setName((String)iterator.next());
                        filterTerm.setOperation("substrings");
                        boolean bl3 = false;
                        while (iterator.hasNext()) {
                            n = (Integer)iterator.next();
                            switch (n) {
                                case 0: {
                                    object.addSubstring((String)iterator.next());
                                    bl3 = false;
                                    break;
                                }
                                case 1: {
                                    object.addSubstring((String)iterator.next());
                                    bl3 = false;
                                    break;
                                }
                                case 2: {
                                    object.addSubstring((String)iterator.next());
                                }
                            }
                        }
                        if (!bl) break;
                        object.addOperand(filterTerm);
                        break;
                    }
                }
                continue;
            }
            if (!(e instanceof Iterator)) continue;
            this.stringFilter((Iterator)e, (FilterTerm)object);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

