/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.asn1;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class ASN1Length {
    private int length;
    private int encodedLength;

    public ASN1Length() {
    }

    public ASN1Length(int n) {
        this.length = n;
    }

    public ASN1Length(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        ++this.encodedLength;
        if (n == 128) {
            this.length = -1;
        } else if (n < 128) {
            this.length = n;
        } else {
            this.length = 0;
            n &= 0x7F;
            while (n > 0) {
                int n2 = inputStream.read();
                ++this.encodedLength;
                if (n2 < 0) {
                    throw new EOFException("BERDecoder: decode: EOF in ASN1Length");
                }
                this.length = (this.length << 8) + n2;
                --n;
            }
        }
    }

    public final void reset(InputStream inputStream) throws IOException {
        this.encodedLength = 0;
        int n = inputStream.read();
        ++this.encodedLength;
        if (n == 128) {
            this.length = -1;
        } else if (n < 128) {
            this.length = n;
        } else {
            this.length = 0;
            n &= 0x7F;
            while (n > 0) {
                int n2 = inputStream.read();
                ++this.encodedLength;
                if (n2 < 0) {
                    throw new EOFException("BERDecoder: decode: EOF in ASN1Length");
                }
                this.length = (this.length << 8) + n2;
                --n;
            }
        }
    }

    public final int getLength() {
        return this.length;
    }

    public final int getEncodedLength() {
        return this.encodedLength;
    }
}

