/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.events;

import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPResponse;
import com.novell.ldap.LDAPSearchConstraints;
import com.novell.ldap.LDAPSearchQueue;
import com.novell.ldap.LDAPSearchResult;
import com.novell.ldap.LDAPSearchResultReference;
import com.novell.ldap.controls.LDAPEntryChangeControl;
import com.novell.ldap.controls.LDAPPersistSearchControl;
import com.novell.ldap.events.LDAPEvent;
import com.novell.ldap.events.LDAPEventListener;
import com.novell.ldap.events.LDAPEventSource;
import com.novell.ldap.events.LDAPExceptionEvent;
import com.novell.ldap.events.PSearchEventListener;
import com.novell.ldap.events.SearchReferralEvent;
import com.novell.ldap.events.SearchResultEvent;

public class PsearchEventSource
extends LDAPEventSource {
    public final void removeListener(PSearchEventListener pSearchEventListener) throws LDAPException {
        if (pSearchEventListener == null) {
            throw new IllegalArgumentException("No parameter can be Null.");
        }
        super.stopeventpolling(pSearchEventListener);
    }

    public final void registerforEvent(LDAPConnection lDAPConnection, String string, int n, String string2, String[] stringArray, boolean bl, LDAPSearchConstraints lDAPSearchConstraints, int n2, boolean bl2, PSearchEventListener pSearchEventListener) throws LDAPException {
        if (lDAPConnection == null || string == null || string2 == null || stringArray == null || pSearchEventListener == null) {
            throw new IllegalArgumentException("Null argument specified");
        }
        LDAPSearchConstraints lDAPSearchConstraints2 = null;
        lDAPSearchConstraints2 = lDAPSearchConstraints == null ? new LDAPSearchConstraints() : lDAPSearchConstraints;
        LDAPPersistSearchControl lDAPPersistSearchControl = new LDAPPersistSearchControl(n2, bl2, true, true);
        lDAPSearchConstraints2.setControls(lDAPPersistSearchControl);
        LDAPSearchQueue lDAPSearchQueue = lDAPConnection.search(string, n, string2, stringArray, bl, null, lDAPSearchConstraints2);
        PSearchEventsGenerator pSearchEventsGenerator = null;
        int[] nArray = lDAPSearchQueue.getMessageIDs();
        if (nArray.length != 1) {
            throw new LDAPException(null, 82, "Unable to Obtain Message Id");
        }
        pSearchEventsGenerator = new PSearchEventsGenerator(pSearchEventListener, this);
        super.pollforevents(lDAPSearchQueue, lDAPConnection, pSearchEventsGenerator, nArray[0], this);
    }

    private class PSearchEventsGenerator
    implements LDAPEventListener {
        private PSearchEventListener listener;
        private PsearchEventSource eventsource;

        PSearchEventsGenerator(PSearchEventListener pSearchEventListener, PsearchEventSource psearchEventSource2) {
            this.listener = pSearchEventListener;
            this.eventsource = psearchEventSource2;
        }

        public final void ldapEventNotification(LDAPEvent lDAPEvent) {
            LDAPMessage lDAPMessage = lDAPEvent.getContainedEventInformation();
            if (lDAPMessage != null) {
                switch (lDAPMessage.getType()) {
                    case 19: {
                        SearchReferralEvent searchReferralEvent = new SearchReferralEvent(this.eventsource, (LDAPSearchResultReference)lDAPMessage);
                        this.listener.searchReferalEvent(searchReferralEvent);
                        break;
                    }
                    case 4: {
                        int n = -1;
                        LDAPControl[] lDAPControlArray = lDAPMessage.getControls();
                        for (int i = 0; i < lDAPControlArray.length; ++i) {
                            if (!(lDAPControlArray[i] instanceof LDAPEntryChangeControl)) continue;
                            LDAPEntryChangeControl lDAPEntryChangeControl = (LDAPEntryChangeControl)lDAPControlArray[i];
                            n = lDAPEntryChangeControl.getChangeType();
                        }
                        SearchResultEvent searchResultEvent = new SearchResultEvent(this.eventsource, (LDAPSearchResult)lDAPMessage, n);
                        this.listener.searchResultEvent(searchResultEvent);
                        break;
                    }
                    case 5: {
                        LDAPResponse lDAPResponse = (LDAPResponse)lDAPMessage;
                        int n = lDAPResponse.getResultCode();
                        LDAPEvent lDAPEvent2 = new LDAPEvent(this.eventsource, lDAPResponse, 0, 15);
                        this.listener.ldapEventNotification(lDAPEvent2);
                        break;
                    }
                    default: {
                        lDAPEvent.setEventclassification(0);
                        this.listener.ldapEventNotification(lDAPEvent);
                    }
                }
            }
        }

        public final void ldapExceptionNotification(LDAPExceptionEvent lDAPExceptionEvent) {
            this.listener.ldapExceptionNotification(lDAPExceptionEvent);
        }

        public int hashCode() {
            return this.listener.hashCode();
        }
    }
}

