/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.events;

import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPSearchResult;
import com.novell.ldap.events.LDAPEvent;
import com.novell.ldap.events.PsearchEventSource;

public class SearchResultEvent
extends LDAPEvent {
    public SearchResultEvent(PsearchEventSource psearchEventSource, LDAPSearchResult lDAPSearchResult, int n) {
        super(psearchEventSource, lDAPSearchResult, 0, n);
    }

    public final LDAPEntry getEntry() {
        return ((LDAPSearchResult)this.getContainedEventInformation()).getEntry();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[" + this.getClass().getName() + ":");
        stringBuffer.append("(Classification=LDAP Persistence Search Event)");
        stringBuffer.append("(Type=" + this.getChangeTypeString(this.getType()) + ")");
        stringBuffer.append("(EventInformation:" + this.getStringRepresentaionOfEventInformation() + ")");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private String getStringRepresentaionOfEventInformation() {
        StringBuffer stringBuffer = new StringBuffer();
        LDAPSearchResult lDAPSearchResult = (LDAPSearchResult)this.getContainedEventInformation();
        stringBuffer.append("(Entry=" + lDAPSearchResult.getEntry() + ")");
        LDAPControl[] lDAPControlArray = lDAPSearchResult.getControls();
        if (lDAPControlArray != null) {
            stringBuffer.append("(Controls=");
            for (int i = 0; i < lDAPControlArray.length; ++i) {
                stringBuffer.append("(Control" + (i + 1) + "=" + lDAPControlArray[i] + ")");
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    private String getChangeTypeString(int n) {
        String string;
        switch (n) {
            case 1: {
                string = "ADD";
                break;
            }
            case 4: {
                string = "MODIFY";
                break;
            }
            case 8: {
                string = "MODDN";
                break;
            }
            case 2: {
                string = "DELETE";
                break;
            }
            default: {
                string = "No change type: " + String.valueOf(n);
            }
        }
        return string;
    }
}

